/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CurrentDeptExtend
extends AbstractDynamicRoleMember {
    private final DepartmentApi departmentApi;
    private final OrgUnitApi orgUnitApi;
    private final RuntimeApi runtimeApi;

    @Override
    public Department getDepartment(String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        Department department = null;
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            ProcessInstanceModel processInstance = (ProcessInstanceModel)this.runtimeApi.getProcessInstance(tenantId, processInstanceId).getData();
            orgUnitId = processInstance.getStartUserId();
        }
        OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, orgUnitId).getData();
        for (Department datum : (List)this.departmentApi.listRecursivelyByParentId(tenantId, bureau.getId()).getData()) {
            if (!StringUtils.isNotBlank((CharSequence)datum.getAliasName()) || !"\u7efc\u5408\u90e8".equals(datum.getAliasName())) continue;
            department = datum;
        }
        return department;
    }

    @Override
    public List<OrgUnit> getOrgUnitList() {
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        orgUnitList.add((OrgUnit)this.getDepartment(""));
        return orgUnitList;
    }

    @Override
    public List<OrgUnit> getOrgUnitList(String processInstanceId) {
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        orgUnitList.add((OrgUnit)this.getDepartment(processInstanceId));
        return orgUnitList;
    }

    @Generated
    public CurrentDeptExtend(DepartmentApi departmentApi, OrgUnitApi orgUnitApi, RuntimeApi runtimeApi) {
        this.departmentApi = departmentApi;
        this.orgUnitApi = orgUnitApi;
        this.runtimeApi = runtimeApi;
    }
}

