/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.controller.vo.Y9FormVO;
import net.risesoft.entity.Y9PreFormItemBind;
import net.risesoft.entity.form.Y9Form;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9FormRepository;
import net.risesoft.service.config.Y9PreFormItemBindService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/preFormBind"}, produces={"application/json"})
public class Y9PreFormItemBindRestController {
    private final Y9PreFormItemBindService y9PreFormItemBindService;
    private final Y9FormRepository y9FormRepository;

    @PostMapping(value={"/deleteBind"})
    public Y9Result<String> deleteBind(@RequestParam String id) {
        return this.y9PreFormItemBindService.delete(id);
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<Y9PreFormItemBind> getBindList(@RequestParam String itemId) {
        Y9PreFormItemBind bind = this.y9PreFormItemBindService.findByItemId(itemId);
        if (bind != null) {
            Y9Form form = this.y9FormRepository.findById((Object)bind.getFormId()).orElse(null);
            bind.setFormName(form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return Y9Result.success((Object)bind, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getFormList"})
    public Y9Result<List<Y9FormVO>> getFormList(@RequestParam String itemId, @RequestParam String systemName, @RequestParam(required=false) String formName) {
        ArrayList<Y9FormVO> listmap = new ArrayList<Y9FormVO>();
        List list = this.y9FormRepository.findBySystemNameAndFormNameLike(systemName, "%" + formName + "%");
        Y9PreFormItemBind bind = this.y9PreFormItemBindService.findByItemId(itemId);
        for (Y9Form y9Form : list) {
            boolean isBind = bind != null && bind.getFormId().equals(y9Form.getId());
            if (isBind) continue;
            Y9FormVO form = new Y9FormVO();
            form.setFormId(y9Form.getId());
            form.setFormName(y9Form.getFormName());
            listmap.add(form);
        }
        return Y9Result.success(listmap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveBindForm"})
    public Y9Result<String> saveBindForm(String itemId, String formId, String formName) {
        return this.y9PreFormItemBindService.saveBindForm(itemId, formId, formName);
    }

    @Generated
    public Y9PreFormItemBindRestController(Y9PreFormItemBindService y9PreFormItemBindService, Y9FormRepository y9FormRepository) {
        this.y9PreFormItemBindService = y9PreFormItemBindService;
        this.y9FormRepository = y9FormRepository;
    }
}

