/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.entity.ItemWordTemplateBind;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.WordTemplate;
import net.risesoft.exception.GlobalErrorCodeEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.WordTemplateService;
import net.risesoft.service.config.ItemWordTemplateBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemWordBind"}, produces={"application/json"})
public class ItemWordTemplateBindController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemWordTemplateBindController.class);
    private final WordTemplateService wordTemplateService;
    private final ItemWordTemplateBindService itemWordTemplateBindService;
    private final SpmApproveItemService spmApproveItemService;
    private final RepositoryApi repositoryApi;
    private final OrgUnitApi orgUnitApi;

    @PostMapping(value={"/clearBindStatus"})
    public Y9Result<String> clearBindStatus(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        try {
            this.itemWordTemplateBindService.clearBindStatus(itemId, processDefinitionId);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u7ed1\u5b9a\u72b6\u6001\u5931\u8d25", (Throwable)e);
            Y9Result.failure((String)"\u66f4\u65b0\u7ed1\u5b9a\u72b6\u6001\u5931\u8d25");
        }
        return Y9Result.successMsg((String)"\u66f4\u65b0\u7ed1\u5b9a\u72b6\u6001\u6210\u529f");
    }

    @PostMapping(value={"/deleteBind"})
    public Y9Result<String> deleteBind(@RequestParam String id) {
        this.itemWordTemplateBindService.deleteBind(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6b63\u6587\u6a21\u677f\u7ed1\u5b9a\u6210\u529f");
    }

    @GetMapping(value={"/getBindWordTemplateList"})
    public Y9Page<Map<String, Object>> getBindWordTemplateList(@RequestParam(required=false) String itemId, int page, int rows) {
        try {
            ArrayList listMap = new ArrayList();
            SpmApproveItem item = this.spmApproveItemService.findById(itemId);
            List<ItemWordTemplateBind> list = this.itemWordTemplateBindService.listByItemIdOrderByBindValueAsc(itemId);
            for (ItemWordTemplateBind itemWordTemplateBind : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", itemWordTemplateBind.getId());
                map.put("itemId", itemWordTemplateBind.getItemId());
                map.put("itemName", item.getName());
                map.put("templateId", itemWordTemplateBind.getTemplateId());
                WordTemplate word = this.wordTemplateService.findById(itemWordTemplateBind.getTemplateId());
                map.put("templateName", "");
                map.put("bindStatus", itemWordTemplateBind.getBindStatus());
                map.put("bindValue", itemWordTemplateBind.getBindValue());
                map.put("processDefinitionId", itemWordTemplateBind.getProcessDefinitionId());
                if (null == word || !StringUtils.isNotBlank((CharSequence)word.getId())) continue;
                map.put("templateName", word.getFileName());
                listMap.add(map);
            }
            return Y9Page.success((int)page, (int)(list.size() / rows), (long)list.size(), listMap);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return Y9Page.failure((int)page, (int)0, (long)0L, new ArrayList(), (String)"\u83b7\u53d6\u5931\u8d25", (long)GlobalErrorCodeEnum.FAILURE.getCode());
        }
    }

    @GetMapping(value={"/getTemplateBind"})
    public Y9Result<Map<String, Object>> getTemplateBind(@RequestParam String itemId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefinitionKey = item.getWorkflowGuid();
        String tenantId = Y9LoginUserHolder.getTenantId();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
        String processDefinitionId = processDefinition.getId();
        map.put("processDefinitionId", processDefinitionId);
        List<WordTemplate> templateList = this.wordTemplateService.listAll();
        ItemWordTemplateBind wordTemplateBind = this.itemWordTemplateBindService.findByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
        String tempName = "";
        String bindId = "";
        if (wordTemplateBind != null) {
            for (WordTemplate wordTemplate : templateList) {
                if (!wordTemplateBind.getTemplateId().equals(wordTemplate.getId())) continue;
                tempName = wordTemplate.getFileName();
                bindId = wordTemplateBind.getId();
            }
        }
        map.put("tempName", tempName);
        map.put("bindId", bindId);
        map.put("templateList", templateList);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getWordTemplateList"})
    public Y9Page<Map<String, Object>> getWordTemplateList(@RequestParam(required=false) String fileName, int page, int rows) {
        try {
            ArrayList items = new ArrayList();
            String personId = Y9LoginUserHolder.getPersonId();
            String tenantId = Y9LoginUserHolder.getTenantId();
            List<WordTemplate> list = null;
            String bureauId = ((OrgUnit)this.orgUnitApi.getBureau(tenantId, personId).getData()).getId();
            list = StringUtils.isNotBlank((CharSequence)fileName) ? this.wordTemplateService.listByBureauIdAndFileNameContainingOrderByUploadTimeDesc(bureauId, fileName) : this.wordTemplateService.listByBureauIdOrderByUploadTimeDesc(bureauId);
            for (WordTemplate wordTemplate : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", wordTemplate.getId());
                map.put("fileName", wordTemplate.getFileName());
                map.put("fileSize", wordTemplate.getFileSize());
                map.put("fileUrl", wordTemplate.getFilePath());
                map.put("personName", wordTemplate.getPersonName());
                items.add(map);
            }
            return Y9Page.success((int)page, (int)(list.size() / rows), (long)list.size(), items);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return Y9Page.failure((int)page, (int)0, (long)0L, new ArrayList(), (String)"\u83b7\u53d6\u5931\u8d25", (long)GlobalErrorCodeEnum.FAILURE.getCode());
        }
    }

    @PostMapping(value={"/save"})
    public Y9Result<String> save(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String templateId) {
        return this.itemWordTemplateBindService.save(itemId, processDefinitionId, templateId);
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String[] templateId) {
        return this.itemWordTemplateBindService.save(itemId, processDefinitionId, templateId);
    }

    @PostMapping(value={"/saveTemplateValue"})
    public Y9Result<String> saveTemplateValue(@RequestParam String id, @RequestParam String itemId, @RequestParam String bindValue) {
        return this.itemWordTemplateBindService.saveTemplateValue(id, itemId, bindValue);
    }

    @PostMapping(value={"/updateBindStatus"})
    public Y9Result<String> updateBindStatus(@RequestParam String id, @RequestParam String itemId, @RequestParam String processDefinitionId) {
        try {
            this.itemWordTemplateBindService.updateBindStatus(id, itemId, processDefinitionId);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u7ed1\u5b9a\u72b6\u6001\u5931\u8d25", (Throwable)e);
            Y9Result.failure((String)"\u66f4\u65b0\u7ed1\u5b9a\u72b6\u6001\u5931\u8d25");
        }
        return Y9Result.successMsg((String)"\u66f4\u65b0\u7ed1\u5b9a\u72b6\u6001\u6210\u529f");
    }

    @Generated
    public ItemWordTemplateBindController(WordTemplateService wordTemplateService, ItemWordTemplateBindService itemWordTemplateBindService, SpmApproveItemService spmApproveItemService, RepositoryApi repositoryApi, OrgUnitApi orgUnitApi) {
        this.wordTemplateService = wordTemplateService;
        this.itemWordTemplateBindService = itemWordTemplateBindService;
        this.spmApproveItemService = spmApproveItemService;
        this.repositoryApi = repositoryApi;
        this.orgUnitApi = orgUnitApi;
    }
}

