/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemWordConf;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.config.ItemWordConfService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemWordConf"}, produces={"application/json"})
public class ItemWordConfRestController {
    private final ItemWordConfService itemWordConfService;
    private final ProcessDefinitionApi processDefinitionApi;

    @PostMapping(value={"/bindRole"})
    public Y9Result<String> bindRole(@RequestParam String roleIds, @RequestParam String id) {
        this.itemWordConfService.bindRole(id, roleIds);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/deleteRole"})
    public Y9Result<String> deleteRole(@RequestParam String roleId, @RequestParam String id) {
        this.itemWordConfService.deleteRole(id, roleId);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemWordConf>> getBindList(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        List<ItemWordConf> oftrbList = this.itemWordConfService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
        return Y9Result.success(oftrbList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<TargetModel>> getBpmList(@RequestParam String processDefinitionId, @RequestParam String itemId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId).getData();
        for (TargetModel targetModel : list) {
            StringBuilder names = new StringBuilder();
            List<ItemWordConf> bindList = this.itemWordConfService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, targetModel.getTaskDefKey());
            for (ItemWordConf bind : bindList) {
                if (StringUtils.isEmpty((CharSequence)names)) {
                    names.append(bind.getWordType());
                    continue;
                }
                names.append("\u3001" + bind.getWordType());
            }
            targetModel.setBindNames(names.toString());
        }
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String id) {
        this.itemWordConfService.delete(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(@RequestParam String wordType, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        this.itemWordConfService.save(wordType, itemId, processDefinitionId, taskDefKey);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemWordConfRestController(ItemWordConfService itemWordConfService, ProcessDefinitionApi processDefinitionApi) {
        this.itemWordConfService = itemWordConfService;
        this.processDefinitionApi = processDefinitionApi;
    }
}

