/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.entity.ItemViewConf;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.form.Y9FormField;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemViewConfService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.service.form.Y9FormFieldService;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemViewConf"}, produces={"application/json"})
public class ItemViewConfRestController {
    private final Y9FormItemBindService y9FormItemBindService;
    private final SpmApproveItemService spmApproveItemService;
    private final ItemViewConfService itemViewConfService;
    private final RepositoryApi repositoryApi;
    private final Y9FormFieldService y9FormFieldService;
    private final Y9TableService y9TableService;

    @PostMapping(value={"/copyView"})
    public Y9Result<String> copyView(String[] ids, String viewType) {
        this.itemViewConfService.copyView(ids, viewType);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/findByItemId"})
    public Y9Result<List<ItemViewConf>> findByItemId(@RequestParam String itemId, @RequestParam String viewType) {
        List<ItemViewConf> list = this.itemViewConfService.listByItemIdAndViewType(itemId, viewType);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getColumns"})
    public Y9Result<List<Y9FormField>> getColumns(@RequestParam String tableName, @RequestParam String itemId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<Y9FormField> list = new ArrayList<Y9FormField>();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefineKey = item.getWorkflowGuid();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefineKey).getData();
        List<Y9FormItemBind> formList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKeyIsNull(itemId, processDefinition.getId());
        for (Y9FormItemBind bind : formList) {
            List<Y9FormField> formFieldList = this.y9FormFieldService.listByTableNameAndFormId(tableName, bind.getFormId());
            for (Y9FormField formField : formFieldList) {
                if (fieldNameList.contains(formField.getFieldName()) || formField.getFieldName().equalsIgnoreCase("guid") || formField.getFieldName().equalsIgnoreCase("processInstanceId")) continue;
                list.add(formField);
                fieldNameList.add(formField.getFieldName());
            }
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/newOrModify"})
    public Y9Result<Map<String, Object>> newOrModify(@RequestParam(required=false) String id, @RequestParam String itemId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        String tenantId = Y9LoginUserHolder.getTenantId();
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefineKey = item.getWorkflowGuid();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefineKey).getData();
        List<Y9FormItemBind> formList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKeyIsNull(itemId, processDefinition.getId());
        ArrayList<Y9Table> tableList = new ArrayList<Y9Table>();
        ArrayList tableField = new ArrayList();
        for (Y9FormItemBind bind : formList) {
            String formId = bind.getFormId();
            List<Y9FormField> formFieldList = this.y9FormFieldService.listByFormId(formId);
            for (Y9FormField formField : formFieldList) {
                Y9FormField oldformField;
                Y9Table y9Table = this.y9TableService.findById(formField.getTableId());
                if (!tableList.contains(y9Table)) {
                    tableList.add(y9Table);
                }
                List<Y9FormField> fieldlist = new ArrayList();
                HashMap<String, Object> tableFieldMap = tableField.stream().filter(t -> t.get("tableName").equals(y9Table.getTableName())).findFirst().orElse(null);
                if (tableFieldMap == null) {
                    tableFieldMap = new HashMap<String, Object>();
                    tableFieldMap.put("tableName", y9Table.getTableName());
                    if (y9Table.getTableName().equals(formField.getTableName())) {
                        fieldlist.add(formField);
                    }
                    tableFieldMap.put("fieldlist", fieldlist);
                    tableField.add(tableFieldMap);
                    continue;
                }
                fieldlist = (List)tableFieldMap.get("fieldlist");
                if (y9Table.getTableName().equals(formField.getTableName()) && (oldformField = (Y9FormField)fieldlist.stream().filter(t -> t.getFieldName().equals(formField.getFieldName())).findFirst().orElse(null)) == null) {
                    fieldlist.add(formField);
                }
                tableFieldMap.put("fieldlist", fieldlist);
                for (Map map : tableField) {
                    if (!map.get("tableName").equals(y9Table.getTableName())) continue;
                    map.put("fieldlist", fieldlist);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ItemViewConf itemViewConf = this.itemViewConfService.findById(id);
            resMap.put("itemViewConf", itemViewConf);
        }
        resMap.put("tableList", tableList);
        resMap.put("tablefield", tableField);
        return Y9Result.success(resMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/newOrModify4Custom"})
    public Y9Result<ItemViewConf> newOrModify4Custom(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ItemViewConf itemViewConf = this.itemViewConfService.findById(id);
            return Y9Result.success((Object)itemViewConf, (String)"\u83b7\u53d6\u6210\u529f");
        }
        return Y9Result.success(null, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeView"})
    public Y9Result<String> removeView(@RequestParam String[] ids) {
        this.itemViewConfService.removeItemViewConfs(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(ItemViewConf itemViewConf) {
        this.itemViewConfService.saveOrUpdate(itemViewConf);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(@RequestParam String[] idAndTabIndexs) {
        this.itemViewConfService.update4Order(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemViewConfRestController(Y9FormItemBindService y9FormItemBindService, SpmApproveItemService spmApproveItemService, ItemViewConfService itemViewConfService, RepositoryApi repositoryApi, Y9FormFieldService y9FormFieldService, Y9TableService y9TableService) {
        this.y9FormItemBindService = y9FormItemBindService;
        this.spmApproveItemService = spmApproveItemService;
        this.itemViewConfService = itemViewConfService;
        this.repositoryApi = repositoryApi;
        this.y9FormFieldService = y9FormFieldService;
        this.y9TableService = y9TableService;
    }
}

