/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemStartNodeRole;
import net.risesoft.model.platform.Role;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.config.ItemStartNodeRoleService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemStartNodeRole"}, produces={"application/json"})
public class ItemStartNodeRoleController {
    private final ItemStartNodeRoleService itemStartNodeRoleService;
    private final ProcessDefinitionApi processDefinitionApi;

    @PostMapping(value={"/copyBind"})
    public Y9Result<String> copyBind(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemStartNodeRoleService.copyBind(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<ItemStartNodeRole>> getBpmList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<ItemStartNodeRole> oldList = this.itemStartNodeRoleService.listByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
        if (oldList.isEmpty()) {
            String startNode = (String)this.processDefinitionApi.getStartNodeKeyByProcessDefinitionId(tenantId, processDefinitionId).getData();
            List nodeList = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, startNode).getData();
            for (TargetModel targetModel : nodeList) {
                this.itemStartNodeRoleService.initRole(itemId, processDefinitionId, targetModel.getTaskDefKey(), targetModel.getTaskDefName());
            }
            oldList = this.itemStartNodeRoleService.listByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
        }
        for (ItemStartNodeRole isnr : oldList) {
            Object roleNames = "";
            List<Role> roleList = this.itemStartNodeRoleService.listRoleByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, isnr.getTaskDefKey());
            for (Role role : roleList) {
                if (StringUtils.isEmpty((CharSequence)roleNames)) {
                    roleNames = role.getName();
                    continue;
                }
                roleNames = (String)roleNames + "\u3001" + role.getName();
            }
            isnr.setRoleNames((String)roleNames);
        }
        return Y9Result.success(oldList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getNodeList"})
    public Y9Result<List<ItemStartNodeRole>> getNodeList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<ItemStartNodeRole> oldList = this.itemStartNodeRoleService.listByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
        if (oldList.isEmpty()) {
            String startNode = (String)this.processDefinitionApi.getStartNodeKeyByProcessDefinitionId(tenantId, processDefinitionId).getData();
            List nodeList = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, startNode).getData();
            for (TargetModel targetModel : nodeList) {
                this.itemStartNodeRoleService.initRole(itemId, processDefinitionId, targetModel.getTaskDefKey(), targetModel.getTaskDefName());
            }
            oldList = this.itemStartNodeRoleService.listByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
        }
        return Y9Result.success(oldList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/list"})
    public Y9Result<List<Role>> list(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        List<Role> roleList = this.itemStartNodeRoleService.listRoleByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
        return Y9Result.success(roleList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, @RequestParam String roleIds) {
        this.itemStartNodeRoleService.removeRole(itemId, processDefinitionId, taskDefKey, roleIds);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(@RequestParam String[] idAndTabIndexs) {
        this.itemStartNodeRoleService.saveOrder(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveRole"})
    public Y9Result<String> saveRole(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, @RequestParam String roleIds) {
        this.itemStartNodeRoleService.saveRole(itemId, processDefinitionId, taskDefKey, roleIds);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemStartNodeRoleController(ItemStartNodeRoleService itemStartNodeRoleService, ProcessDefinitionApi processDefinitionApi) {
        this.itemStartNodeRoleService = itemStartNodeRoleService;
        this.processDefinitionApi = processDefinitionApi;
    }
}

