/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemPermission;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.config.ItemPermissionService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9itemadmin.Y9ItemAdminProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemPerm"}, produces={"application/json"})
public class ItemPermissionRestController {
    private final ItemPermissionService itemPermissionService;
    private final ProcessDefinitionApi processDefinitionApi;
    private final Y9ItemAdminProperties y9ItemAdminProperties;

    @PostMapping(value={"/copyPerm"})
    public Y9Result<String> copyPerm(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemPermissionService.copyPerm(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    public Y9Result<String> delete(@RequestParam String id) {
        this.itemPermissionService.delete(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<TargetModel>> getBpmList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId).getData();
        String freeFlowKey = this.y9ItemAdminProperties.getFreeFlowKey();
        if (processDefinitionId.startsWith(freeFlowKey)) {
            TargetModel targetModel = new TargetModel();
            targetModel.setTaskDefKey("freeFlowEndRole");
            targetModel.setTaskDefName("\u529e\u7ed3");
            list.add(targetModel);
        }
        for (TargetModel targetModel : list) {
            Object roleNames = "";
            List<ItemPermission> ipList = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, targetModel.getTaskDefKey());
            for (ItemPermission ip : ipList) {
                if (StringUtils.isEmpty((CharSequence)roleNames)) {
                    roleNames = ip.getRoleName();
                    continue;
                }
                roleNames = (String)roleNames + "\u3001" + ip.getRoleName();
            }
            targetModel.setRoleNames((String)roleNames);
        }
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<Map<String, Object>>> getPerm(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        ArrayList list = new ArrayList();
        List<ItemPermission> itemPermissionList = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
        for (ItemPermission o : itemPermissionList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", o.getId());
            map.put("roleId", o.getRoleId());
            map.put("roleName", o.getRoleName());
            map.put("roleType", o.getRoleType());
            list.add(map);
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removePerm"})
    public Y9Result<String> removePerm(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemPermissionService.removePerm(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u6e05\u7a7a\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> save(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey, @RequestParam String roleId, @RequestParam Integer roleType) {
        if (roleId.contains(";")) {
            String[] roleIds;
            for (String roleIdTemp : roleIds = roleId.split(";")) {
                this.itemPermissionService.save(itemId, processDefinitionId, taskDefKey, roleIdTemp, roleType);
            }
        } else {
            this.itemPermissionService.save(itemId, processDefinitionId, taskDefKey, roleId, roleType);
        }
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemPermissionRestController(ItemPermissionService itemPermissionService, ProcessDefinitionApi processDefinitionApi, Y9ItemAdminProperties y9ItemAdminProperties) {
        this.itemPermissionService = itemPermissionService;
        this.processDefinitionApi = processDefinitionApi;
        this.y9ItemAdminProperties = y9ItemAdminProperties;
    }
}

