/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemOrganWordBind;
import net.risesoft.entity.OrganWord;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OrganWordService;
import net.risesoft.service.config.ItemOrganWordBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemOrganWordBind"}, produces={"application/json"})
public class ItemOrganWordBindController {
    private final ItemOrganWordBindService itemOrganWordBindService;
    private final OrganWordService organWordService;
    private final ProcessDefinitionApi processDefinitionApi;

    @PostMapping(value={"/copyBind"})
    public Y9Result<String> copyBind(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemOrganWordBindService.copyBind(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemOrganWordBind>> getBindList(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        List<ItemOrganWordBind> list = this.itemOrganWordBindService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<TargetModel>> getBpmList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId).getData();
        for (TargetModel targetModel : list) {
            StringBuilder bindNames = new StringBuilder();
            List<ItemOrganWordBind> bindList = this.itemOrganWordBindService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, targetModel.getTaskDefKey());
            for (ItemOrganWordBind cb : bindList) {
                if (StringUtils.isEmpty((CharSequence)bindNames)) {
                    bindNames.append(cb.getOrganWordName());
                    continue;
                }
                bindNames.append("\u3001" + cb.getOrganWordName());
            }
            targetModel.setBindNames(bindNames.toString());
        }
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrganWordList"})
    public Y9Result<List<OrganWord>> getOrganWordList(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        List<ItemOrganWordBind> bindList = this.itemOrganWordBindService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
        List<OrganWord> owList = this.organWordService.listAll();
        List<Object> owListTemp = new ArrayList();
        if (bindList.isEmpty()) {
            owListTemp = owList;
        } else {
            for (OrganWord cb : owList) {
                boolean isBind = false;
                for (ItemOrganWordBind bind : bindList) {
                    if (!bind.getOrganWordCustom().equals(cb.getCustom())) continue;
                    isBind = true;
                    break;
                }
                if (isBind) continue;
                owListTemp.add(cb);
            }
        }
        return Y9Result.success(owListTemp, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeBind"})
    public Y9Result<String> removeBind(String id) {
        this.itemOrganWordBindService.remove(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(@RequestParam String custom, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        this.itemOrganWordBindService.save(custom, itemId, processDefinitionId, taskDefKey);
        return Y9Result.successMsg((String)"\u7ed1\u5b9a\u6210\u529f");
    }

    @Generated
    public ItemOrganWordBindController(ItemOrganWordBindService itemOrganWordBindService, OrganWordService organWordService, ProcessDefinitionApi processDefinitionApi) {
        this.itemOrganWordBindService = itemOrganWordBindService;
        this.organWordService = organWordService;
        this.processDefinitionApi = processDefinitionApi;
    }
}

