/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.entity.ItemMappingConf;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.form.Y9FormField;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemMappingConfRepository;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemMappingConfService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.service.form.Y9FormFieldService;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemMappingConf"}, produces={"application/json"})
public class ItemMappingConfRestController {
    private final Y9FormItemBindService y9FormItemBindService;
    private final SpmApproveItemService spmApproveItemService;
    private final ItemMappingConfService itemMappingConfService;
    private final ItemMappingConfRepository itemMappingConfRepository;
    private final RepositoryApi repositoryApi;
    private final Y9FormFieldService y9FormFieldService;
    private final Y9TableService y9TableService;

    @GetMapping(value={"/getColumns"})
    public Y9Result<List<Y9FormField>> getColumns(@RequestParam String tableName) {
        ArrayList<Y9FormField> list = new ArrayList<Y9FormField>();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        List<Y9FormField> formFieldList = this.y9FormFieldService.listByTableName(tableName);
        for (Y9FormField formField : formFieldList) {
            if (fieldNameList.contains(formField.getFieldName())) continue;
            list.add(formField);
            fieldNameList.add(formField.getFieldName());
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getConfInfo"})
    public Y9Result<Map<String, Object>> getConfInfo(@RequestParam(required=false) String id, @RequestParam String itemId, @RequestParam(required=false) String mappingItemId) {
        HashMap resMap = new HashMap(16);
        String tenantId = Y9LoginUserHolder.getTenantId();
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefineKey = item.getWorkflowGuid();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefineKey).getData();
        List<Y9FormItemBind> formList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKeyIsNull(itemId, processDefinition.getId());
        ArrayList<String> tableNameList = new ArrayList<String>();
        ArrayList<Y9Table> tableList = new ArrayList<Y9Table>();
        for (Y9FormItemBind bind : formList) {
            String formId = bind.getFormId();
            List<Y9FormField> formFieldList = this.y9FormFieldService.listByFormId(formId);
            for (Y9FormField formField : formFieldList) {
                if (tableNameList.contains(formField.getTableName())) continue;
                Y9Table y9Table = this.y9TableService.findById(formField.getTableId());
                tableNameList.add(formField.getTableName());
                tableList.add(y9Table);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mappingItemId)) {
            SpmApproveItem item1 = this.spmApproveItemService.findById(mappingItemId);
            String processDefineKey1 = item1.getWorkflowGuid();
            ProcessDefinitionModel processDefinition1 = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefineKey1).getData();
            List<Y9FormItemBind> formList1 = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKeyIsNull(mappingItemId, processDefinition1.getId());
            ArrayList<String> tableNameList1 = new ArrayList<String>();
            ArrayList<Y9Table> tableList1 = new ArrayList<Y9Table>();
            for (Y9FormItemBind bind : formList1) {
                String formId = bind.getFormId();
                List<Y9FormField> formFieldList = this.y9FormFieldService.listByFormId(formId);
                for (Y9FormField formField : formFieldList) {
                    if (tableNameList1.contains(formField.getTableName())) continue;
                    Y9Table y9Table = this.y9TableService.findById(formField.getTableId());
                    tableNameList1.add(formField.getTableName());
                    tableList1.add(y9Table);
                }
            }
            resMap.put("mappingTableList", tableList1);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ItemMappingConf itemMappingConf = this.itemMappingConfRepository.findById((Object)id).orElse(null);
            resMap.put("itemMappingConf", itemMappingConf);
        }
        resMap.put("tableList", tableList);
        return Y9Result.success(resMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getList"})
    public Y9Result<List<ItemMappingConf>> getList(@RequestParam String itemId, @RequestParam String mappingId) {
        List<ItemMappingConf> list = this.itemMappingConfService.listByItemIdAndMappingId(itemId, mappingId);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String[] ids) {
        this.itemMappingConfService.delItemMappingConf(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(ItemMappingConf itemMappingConf) {
        this.itemMappingConfService.saveItemMappingConf(itemMappingConf);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemMappingConfRestController(Y9FormItemBindService y9FormItemBindService, SpmApproveItemService spmApproveItemService, ItemMappingConfService itemMappingConfService, ItemMappingConfRepository itemMappingConfRepository, RepositoryApi repositoryApi, Y9FormFieldService y9FormFieldService, Y9TableService y9TableService) {
        this.y9FormItemBindService = y9FormItemBindService;
        this.spmApproveItemService = spmApproveItemService;
        this.itemMappingConfService = itemMappingConfService;
        this.itemMappingConfRepository = itemMappingConfRepository;
        this.repositoryApi = repositoryApi;
        this.y9FormFieldService = y9FormFieldService;
        this.y9TableService = y9TableService;
    }
}

