/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.CommonButton;
import net.risesoft.entity.ItemButtonBind;
import net.risesoft.entity.SendButton;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.enums.ItemButtonTypeEnum;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CommonButtonService;
import net.risesoft.service.SendButtonService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemButtonBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemButtonBind"}, produces={"application/json"})
public class ItemButtonBindRestController {
    private final ItemButtonBindService itemButtonBindService;
    private final CommonButtonService commonButtonService;
    private final SendButtonService sendButtonService;
    private final ProcessDefinitionApi processDefinitionApi;
    private final SpmApproveItemService spmApproveItemService;

    @PostMapping(value={"/copyBind"})
    public Y9Result<String> copyBind(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemButtonBindService.copyBind(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemButtonBind>> getBindList(@RequestParam String itemId, @RequestParam Integer buttonType, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        List<ItemButtonBind> list = this.itemButtonBindService.listContainRole(itemId, buttonType, processDefinitionId, taskDefKey);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindListByButtonId"})
    public Y9Result<List<Map<String, Object>>> getBindListByButtonId(@RequestParam String buttonId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<ItemButtonBind> ibbList = this.itemButtonBindService.listByButtonId(buttonId);
        ArrayList bindList = new ArrayList();
        for (ItemButtonBind bind : ibbList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", bind.getId());
            map.put("processDefinitionId", bind.getProcessDefinitionId());
            map.put("roleNames", bind.getRoleNames());
            SpmApproveItem item = this.spmApproveItemService.findById(bind.getItemId());
            map.put("itemName", null == item ? "\u4e8b\u9879\u4e0d\u5b58\u5728" : item.getName());
            String taskDefName = "\u6574\u4e2a\u6d41\u7a0b";
            if (StringUtils.isNotEmpty((CharSequence)bind.getTaskDefKey())) {
                List list = (List)this.processDefinitionApi.getNodes(tenantId, bind.getProcessDefinitionId()).getData();
                for (TargetModel targetModel : list) {
                    if (!targetModel.getTaskDefKey().equals(bind.getTaskDefKey())) continue;
                    taskDefName = targetModel.getTaskDefName();
                }
            }
            map.put("taskDefKey", taskDefName + (String)(StringUtils.isEmpty((CharSequence)bind.getTaskDefKey()) ? "" : "(" + bind.getTaskDefKey() + ")"));
            bindList.add(map);
        }
        return Y9Result.success(bindList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<TargetModel>> getBpmList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId).getData();
        for (TargetModel targetModel : list) {
            Object commonButtonNames = "";
            Object sendButtonNames = "";
            List<ItemButtonBind> cbList = this.itemButtonBindService.listContainRole(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, targetModel.getTaskDefKey());
            List<ItemButtonBind> sbList = this.itemButtonBindService.listContainRole(itemId, ItemButtonTypeEnum.SEND.getValue(), processDefinitionId, targetModel.getTaskDefKey());
            for (ItemButtonBind cb : cbList) {
                if (StringUtils.isEmpty((CharSequence)commonButtonNames)) {
                    commonButtonNames = cb.getButtonName();
                    continue;
                }
                commonButtonNames = (String)commonButtonNames + "\u3001" + cb.getButtonName();
            }
            for (ItemButtonBind sb : sbList) {
                if (StringUtils.isEmpty((CharSequence)sendButtonNames)) {
                    sendButtonNames = sb.getButtonName();
                    continue;
                }
                sendButtonNames = (String)sendButtonNames + "\u3001" + sb.getButtonName();
            }
            targetModel.setCommonButtonNames((String)commonButtonNames);
            targetModel.setSendButtonNames((String)sendButtonNames);
        }
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getButtonList"})
    public Y9Result<Map<String, Object>> getButtonList(@RequestParam String itemId, @RequestParam Integer buttonType, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        List<ItemButtonBind> buttonItemBindList = this.itemButtonBindService.listByItemIdAndButtonTypeAndProcessDefinitionIdAndTaskDefKey(itemId, buttonType, processDefinitionId, taskDefKey);
        if (1 == buttonType) {
            List<CommonButton> cbList = this.commonButtonService.listAll();
            List<Object> cbListTemp = new ArrayList();
            if (buttonItemBindList.isEmpty()) {
                cbListTemp = cbList;
            } else {
                for (CommonButton cb : cbList) {
                    boolean isBind = false;
                    for (ItemButtonBind bib : buttonItemBindList) {
                        if (!bib.getButtonId().equals(cb.getId())) continue;
                        isBind = true;
                        break;
                    }
                    if (isBind) continue;
                    cbListTemp.add(cb);
                }
            }
            map.put("rows", cbListTemp);
        } else {
            List<SendButton> sbList = this.sendButtonService.listAll();
            List<Object> sbListTemp = new ArrayList();
            if (buttonItemBindList.isEmpty()) {
                sbListTemp = sbList;
            } else {
                for (SendButton sb : sbList) {
                    boolean isBind = false;
                    for (ItemButtonBind bib : buttonItemBindList) {
                        if (!bib.getButtonId().equals(sb.getId())) continue;
                        isBind = true;
                        break;
                    }
                    if (isBind) continue;
                    sbListTemp.add(sb);
                }
            }
            map.put("rows", sbListTemp);
        }
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getButtonOrderList"})
    public Y9Result<List<ItemButtonBind>> getButtonOrderList(@RequestParam String itemId, @RequestParam Integer buttonType, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        List<ItemButtonBind> list = this.itemButtonBindService.listByItemIdAndButtonTypeAndProcessDefinitionIdAndTaskDefKey(itemId, buttonType, processDefinitionId, taskDefKey);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeBind"})
    public Y9Result<String> removeBind(@RequestParam String[] ids) {
        this.itemButtonBindService.removeButtonItemBinds(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBindButton"})
    public Y9Result<String> saveBindButton(@RequestParam String buttonId, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam Integer buttonType, @RequestParam(required=false) String taskDefKey) {
        this.itemButtonBindService.bindButton(itemId, buttonId, processDefinitionId, taskDefKey, buttonType);
        return Y9Result.successMsg((String)"\u7ed1\u5b9a\u6210\u529f");
    }

    @PostMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(@RequestParam String[] idAndTabIndexs) {
        this.itemButtonBindService.saveOrder(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemButtonBindRestController(ItemButtonBindService itemButtonBindService, CommonButtonService commonButtonService, SendButtonService sendButtonService, ProcessDefinitionApi processDefinitionApi, SpmApproveItemService spmApproveItemService) {
        this.itemButtonBindService = itemButtonBindService;
        this.commonButtonService = commonButtonService;
        this.sendButtonService = sendButtonService;
        this.processDefinitionApi = processDefinitionApi;
        this.spmApproveItemService = spmApproveItemService;
    }
}

