/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.controller.vo.WordTemplateVO;
import net.risesoft.entity.BookMarkBind;
import net.risesoft.entity.WordTemplate;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.entity.form.Y9TableField;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.BookMarkBindService;
import net.risesoft.service.WordTemplateService;
import net.risesoft.service.form.Y9TableFieldService;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/vue/wordTemplate"}, produces={"application/json"})
public class WordTemplateRestController {
    private final WordTemplateService wordTemplateService;
    private final OrgUnitApi orgUnitApi;
    private final BookMarkBindService bookMarkBindService;
    private final Y9TableService y9TableService;
    private final Y9TableFieldService y9TableFieldService;

    @RequestMapping(value={"/bookMarKList"})
    public Y9Result<List<Map<String, Object>>> bookMarkList(String wordTemplateId, @RequestParam String wordTemplateType) {
        List<Map<String, Object>> list = this.wordTemplateService.listBookMarkByWordTemplateIdAndWordTemplateType(wordTemplateId, wordTemplateType);
        return Y9Result.success(list);
    }

    @PostMapping(value={"/deleteWordTemplate"})
    public Y9Result<String> deleteWordTemplate(@RequestParam String id) {
        return this.wordTemplateService.deleteWordTemplate(id);
    }

    @RequestMapping(value={"/download"})
    public void download(@RequestParam String id, HttpServletResponse response, HttpServletRequest request) {
        this.wordTemplateService.download(id, response, request);
    }

    @GetMapping(value={"/getBookMarkBind"})
    public Y9Result<Map<String, Object>> getBookMarkBind(@RequestParam String bookMarkName, @RequestParam String wordTemplateId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        List<Y9Table> tableList = this.y9TableService.listAllTable();
        ArrayList<String> columnList = new ArrayList<String>();
        BookMarkBind bookMarkBind = this.bookMarkBindService.findByWordTemplateIdAndBookMarkName(wordTemplateId, bookMarkName);
        if (null != bookMarkBind) {
            String tableId = "";
            for (Y9Table table : tableList) {
                if (!table.getTableName().equals(bookMarkBind.getTableName())) continue;
                tableId = table.getId();
            }
            if (!tableId.isEmpty()) {
                List<Y9TableField> fieldList = this.y9TableFieldService.listByTableId(tableId);
                for (Y9TableField field : fieldList) {
                    columnList.add(field.getFieldName());
                }
            }
        }
        resMap.put("bookMarkBind", bookMarkBind);
        resMap.put("columnList", columnList);
        resMap.put("tableList", tableList);
        return Y9Result.success(resMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getColumns"})
    public Y9Result<List<String>> getColumns(@RequestParam String tableId) {
        ArrayList<String> columnList = new ArrayList<String>();
        List<Y9TableField> fieldList = this.y9TableFieldService.listByTableId(tableId);
        for (Y9TableField field : fieldList) {
            columnList.add(field.getFieldName());
        }
        return Y9Result.success(columnList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/upload"})
    public Y9Result<String> upload(MultipartFile file) {
        return this.wordTemplateService.upload(file);
    }

    @GetMapping(value={"/wordTemplateList"})
    public Y9Result<List<WordTemplateVO>> wordTemplateList() {
        UserInfo person = Y9LoginUserHolder.getUserInfo();
        String personId = person.getPersonId();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<WordTemplate> list = person.isGlobalManager() ? this.wordTemplateService.listAll() : this.wordTemplateService.listByBureauIdOrderByUploadTimeDesc(((OrgUnit)this.orgUnitApi.getBureau(tenantId, personId).getData()).getId());
        ArrayList<WordTemplateVO> items = new ArrayList<WordTemplateVO>();
        for (WordTemplate wordTemplate : list) {
            WordTemplateVO map = new WordTemplateVO();
            map.setId(wordTemplate.getId());
            map.setFileName(wordTemplate.getFileName());
            map.setFileSize(wordTemplate.getFileSize());
            map.setPersonName(wordTemplate.getPersonName());
            map.setUploadTime(wordTemplate.getUploadTime());
            map.setWordTemplateType(wordTemplate.getFileName().endsWith("doc") ? "doc" : "docx");
            map.setFilePath(wordTemplate.getFilePath());
            items.add(map);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @Generated
    public WordTemplateRestController(WordTemplateService wordTemplateService, OrgUnitApi orgUnitApi, BookMarkBindService bookMarkBindService, Y9TableService y9TableService, Y9TableFieldService y9TableFieldService) {
        this.wordTemplateService = wordTemplateService;
        this.orgUnitApi = orgUnitApi;
        this.bookMarkBindService = bookMarkBindService;
        this.y9TableService = y9TableService;
        this.y9TableFieldService = y9TableFieldService;
    }
}

