/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.entity.SignOutDept;
import net.risesoft.entity.SignOutDeptType;
import net.risesoft.model.platform.Department;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SignDeptOutService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/signDept"}, produces={"application/json"})
public class SignDeptRestController {
    private final SignDeptOutService signDeptOutService;

    @PostMapping(value={"/disableDept"})
    public Y9Result<String> disableDept(@RequestParam String[] ids, @RequestParam Integer status) {
        this.signDeptOutService.disableDept(ids, status);
        return Y9Result.successMsg((String)"\u7981\u7528\u6210\u529f");
    }

    @PostMapping(value={"/disableType"})
    public Y9Result<String> disableType(@RequestParam String id, @RequestParam Integer status) {
        this.signDeptOutService.disableType(id, status);
        return Y9Result.successMsg((String)"\u7981\u7528\u6210\u529f");
    }

    @GetMapping(value={"/getDeptList"})
    public Y9Result<List<SignOutDept>> getDeptList(@RequestParam String deptTypeId, @RequestParam(required=false) String name, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer rows) {
        List<SignOutDept> list = this.signDeptOutService.listAll(deptTypeId, name, page, rows);
        return Y9Result.success(list);
    }

    @GetMapping(value={"/getDeptTypeList"})
    public Y9Result<List<Department>> getDeptTypeList(@RequestParam(required=false) String name) {
        List<SignOutDeptType> list = this.signDeptOutService.getDeptTypeList(name);
        ArrayList<Department> modelList = new ArrayList<Department>();
        for (SignOutDeptType type : list) {
            Department model = new Department();
            model.setId(type.getDeptTypeId());
            model.setName(type.getDeptType());
            model.setTabIndex(type.getTabIndex());
            model.setDisabled(Boolean.valueOf(type.getIsForbidden() == 1));
            modelList.add(model);
        }
        return Y9Result.success(modelList, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String[] ids) {
        this.signDeptOutService.remove(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/removeDetpType"})
    public Y9Result<String> removeDetpType(@RequestParam String id) {
        this.signDeptOutService.removeDetpType(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveDeptOrder"})
    public Y9Result<String> saveDeptOrder(@RequestParam String[] idAndTabIndexs) {
        this.signDeptOutService.saveDeptOrder(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveDetpType"})
    public Y9Result<String> saveDetpType(SignOutDeptType info) {
        this.signDeptOutService.saveDetpType(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(SignOutDept info) {
        this.signDeptOutService.saveOrUpdate(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveTypeOrder"})
    public Y9Result<String> saveTypeOrder(@RequestParam String[] idAndTabIndexs) {
        this.signDeptOutService.saveTypeOrder(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public SignDeptRestController(SignDeptOutService signDeptOutService) {
        this.signDeptOutService = signDeptOutService;
    }
}

