/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.entity.InterfaceInfo;
import net.risesoft.entity.InterfaceRequestParams;
import net.risesoft.entity.InterfaceResponseParams;
import net.risesoft.entity.ItemInterfaceParamsBind;
import net.risesoft.model.InterfaceExportData;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.InterfaceService;
import net.risesoft.service.config.ItemInterfaceParamsBindService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/vue/json"}, produces={"application/json"})
public class JsonImAndExportRestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonImAndExportRestController.class);
    private final InterfaceService interfaceService;
    private final ItemInterfaceParamsBindService itemInterfaceParamsBindService;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");

    @GetMapping(value={"/exportJson"})
    public ResponseEntity<byte[]> exportJson(@RequestParam(required=false) String id, @RequestParam String type) {
        List<InterfaceExportData> dataToExport;
        Object filename = "export";
        switch (type) {
            case "interface": {
                dataToExport = this.buildInterfaceExportData(id);
                filename = dataToExport.get(0).getInterfaceInfo().getInterfaceName();
                break;
            }
            case "interfaceAll": {
                dataToExport = this.buildInterfaceExportData("");
                filename = "\u6240\u6709\u63a5\u53e3\u6570\u636e" + this.sdf.format(new Date());
                break;
            }
            case "interfaceParam": {
                dataToExport = this.buildInterfaceParamBindExportData(id);
                filename = "\u63a5\u53e3\u53c2\u6570" + this.sdf.format(new Date());
                break;
            }
            default: {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u7c7b\u578b".getBytes());
            }
        }
        return this.buildJsonDownloadResponse(dataToExport, (String)filename);
    }

    private List<InterfaceExportData> buildInterfaceExportData(String id) {
        List<Object> interfaceInfoList = new ArrayList<InterfaceInfo>();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            interfaceInfoList.add(this.interfaceService.findById(id));
        } else {
            interfaceInfoList = this.interfaceService.findAll();
        }
        return interfaceInfoList.stream().map(info -> {
            List<InterfaceRequestParams> requestParamsList = this.interfaceService.listRequestParams(null, null, info.getId());
            List<InterfaceResponseParams> responseParamsList = this.interfaceService.listResponseParamsByNameAndId(null, info.getId());
            InterfaceExportData exportData = new InterfaceExportData();
            exportData.setInterfaceInfo(info);
            exportData.setRequestParamsList(requestParamsList);
            exportData.setResponseParamsList(responseParamsList);
            return exportData;
        }).collect(Collectors.toList());
    }

    private List<ItemInterfaceParamsBind> buildInterfaceParamBindExportData(String id) {
        String itemId = id.split(":")[0];
        String interfaceId = id.split(":")[1];
        return this.itemInterfaceParamsBindService.listByItemIdAndInterfaceId(itemId, interfaceId);
    }

    protected ResponseEntity<byte[]> buildJsonDownloadResponse(Object data, String baseFilename) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            String jsonStr = objectMapper.writeValueAsString(data);
            byte[] jsonData = jsonStr.getBytes(StandardCharsets.UTF_8);
            String filename = URLEncoder.encode(baseFilename, StandardCharsets.UTF_8).replace("+", "%20");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=" + filename + ".json; filename*=UTF-8''" + filename + ".json"})).body((Object)jsonData);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa JSON \u5931\u8d25", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"\u5bfc\u51fa\u5931\u8d25".getBytes());
        }
    }

    @PostMapping(value={"/importJson"}, consumes={"multipart/form-data"})
    public Y9Result<String> importJson(MultipartFile file, @RequestParam(required=false) String id, @RequestParam String type) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            switch (type) {
                case "interface": {
                    this.importInterfaceFromJson(file, objectMapper);
                    break;
                }
                case "interfaceParam": {
                    this.importInterfaceParamFromJson(file, id, objectMapper);
                    break;
                }
                default: {
                    return Y9Result.failure((String)"\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u7c7b\u578b");
                }
            }
            return Y9Result.successMsg((String)"\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Y9Result.failure((String)("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private void importInterfaceParamFromJson(MultipartFile file, String id, ObjectMapper objectMapper) {
        try {
            String itemId = id.split(":")[0];
            String interfaceId = id.split(":")[1];
            List exportDataList = (List)objectMapper.readValue(file.getInputStream(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, ItemInterfaceParamsBind.class));
            for (ItemInterfaceParamsBind exportData : exportDataList) {
                exportData.setId(null);
                exportData.setInterfaceId(interfaceId);
                exportData.setItemId(itemId);
                this.itemInterfaceParamsBindService.saveBind(exportData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    private void importInterfaceFromJson(MultipartFile file, ObjectMapper objectMapper) {
        try {
            List exportDataList = (List)objectMapper.readValue(file.getInputStream(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, InterfaceExportData.class));
            for (InterfaceExportData exportData : exportDataList) {
                InterfaceInfo interfaceInfo = exportData.getInterfaceInfo();
                List requestParamsList = exportData.getRequestParamsList();
                List responseParamsList = exportData.getResponseParamsList();
                interfaceInfo.setId(null);
                List<InterfaceInfo> infoList = this.interfaceService.findByInterfaceName(interfaceInfo.getInterfaceName());
                if (infoList.size() > 0) {
                    interfaceInfo.setInterfaceName(interfaceInfo.getInterfaceName() + "-" + infoList.size());
                }
                InterfaceInfo savedInfo = this.interfaceService.saveInterfaceInfo(interfaceInfo);
                for (InterfaceRequestParams param : requestParamsList) {
                    param.setId(null);
                    param.setInterfaceId(savedInfo.getId());
                    this.interfaceService.saveRequestParams(param);
                }
                for (InterfaceRequestParams param : responseParamsList) {
                    param.setId(null);
                    param.setInterfaceId(savedInfo.getId());
                    this.interfaceService.saveResponseParams((InterfaceResponseParams)param);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    @Generated
    public JsonImAndExportRestController(InterfaceService interfaceService, ItemInterfaceParamsBindService itemInterfaceParamsBindService) {
        this.interfaceService = interfaceService;
        this.itemInterfaceParamsBindService = itemInterfaceParamsBindService;
    }
}

