/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.util.Base64;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.resource.AppIconApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.platform.AppIcon;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/vue/item"}, produces={"application/json"})
public class ItemRestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemRestController.class);
    private final SpmApproveItemService spmApproveItemService;
    private final RepositoryApi repositoryApi;
    private final OrganizationApi organizationApi;
    private final DepartmentApi departmentApi;
    private final AppIconApi appIconApi;
    private final OrgUnitApi orgUnitApi;

    @PostMapping(value={"/copyItem"})
    public Y9Result<String> copyItem(@RequestParam(required=true) String id) {
        return this.spmApproveItemService.copyItem(id);
    }

    @PostMapping(value={"/copyAllBind"})
    public Y9Result<String> copyAllBind(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        return this.spmApproveItemService.copyAllBind(itemId, processDefinitionId);
    }

    @PostMapping(value={"/delete"})
    public Y9Result<String> delete(@RequestParam String id) {
        return this.spmApproveItemService.delete(id);
    }

    private boolean deleteDirectory(String sPath) {
        File file;
        File dirFile;
        if (!((String)sPath).endsWith(File.separator)) {
            sPath = (String)sPath + File.separator;
        }
        if (!(dirFile = new File((String)sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        assert (files != null);
        File[] fileArray = files;
        int n = fileArray.length;
        for (int i = 0; i < n && (flag = (file = fileArray[i]).isFile() ? this.deleteFile(file.getAbsolutePath()) : this.deleteDirectory(file.getAbsolutePath())); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    private boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            flag = true;
        }
        return flag;
    }

    @GetMapping(value={"/getBindItemList"})
    public Y9Result<List<SpmApproveItem>> getBindItemList(@RequestParam(required=true) String itemId, @RequestParam(required=true) String itemName) {
        List<SpmApproveItem> itemList = this.spmApproveItemService.listByIdNotAndNameLike(itemId, itemName);
        return Y9Result.success(itemList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @RequestMapping(value={"/getDept"})
    public Y9Result<String> getDept(@RequestParam String id) {
        StringBuilder sb = new StringBuilder();
        this.getJson(sb, id);
        return Y9Result.success((Object)("[" + sb.substring(0, sb.lastIndexOf(",")) + "]"));
    }

    public void getJson(StringBuilder sb, String deptId) {
        block3: {
            String tenantId;
            block2: {
                tenantId = Y9LoginUserHolder.getTenantId();
                if (!StringUtils.isBlank((CharSequence)deptId)) break block2;
                List orgList = (List)this.organizationApi.list(tenantId).getData();
                if (orgList == null || orgList.isEmpty()) break block3;
                List deptList = (List)this.departmentApi.listByParentId(tenantId, ((Organization)orgList.get(0)).getId()).getData();
                for (Department dept : deptList) {
                    List subDeptList = (List)this.departmentApi.listByParentId(tenantId, dept.getId()).getData();
                    boolean isParent = subDeptList != null && !subDeptList.isEmpty();
                    sb.append("{ id:'").append(dept.getId()).append("', pId:'").append(((Organization)orgList.get(0)).getId()).append("', name:'").append(dept.getName()).append("', isParent: ").append(isParent).append("},");
                }
                break block3;
            }
            List deptList = (List)this.departmentApi.listByParentId(tenantId, deptId).getData();
            for (Department dept : deptList) {
                List subDeptList = (List)this.departmentApi.listByParentId(tenantId, dept.getId()).getData();
                boolean isParent = subDeptList != null && !subDeptList.isEmpty();
                sb.append("{ id:'").append(dept.getId()).append("', pId:'").append(deptId).append("', name:'").append(dept.getName()).append("', isParent: ").append(isParent).append("},");
            }
        }
    }

    @GetMapping(value={"/list"})
    public Y9Result<List<SpmApproveItem>> list() {
        List<SpmApproveItem> list = this.spmApproveItemService.list();
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/newOrModify"})
    public Y9Result<Map<String, Object>> newOrModify(@RequestParam(required=false) String id) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String tenantId = Y9LoginUserHolder.getTenantId();
        SpmApproveItem item = new SpmApproveItem();
        item.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        ArrayList<OrgUnit> manager = new ArrayList<OrgUnit>();
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)(item = this.spmApproveItemService.findById(id)).getNature())) {
            String idStr = item.getNature();
            for (String userId : idStr.split(";")) {
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
                if (orgUnit == null) continue;
                manager.add(orgUnit);
            }
        }
        map.put("item", item);
        map.put("manager", manager);
        ArrayList workflowList = new ArrayList();
        List pdModelList = (List)this.repositoryApi.getLatestProcessDefinitionList(tenantId).getData();
        for (ProcessDefinitionModel pdModel : pdModelList) {
            HashMap<String, String> row = new HashMap<String, String>(16);
            row.put("id", pdModel.getKey());
            row.put("name", pdModel.getName());
            workflowList.add(row);
        }
        map.put("workflowList", workflowList);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/publishToSystemApp"})
    public Y9Result<String> publishToSystemApp(@RequestParam String itemId) {
        return this.spmApproveItemService.publishToSystemApp(itemId);
    }

    @GetMapping(value={"/readAppIconFile"})
    public Y9Result<Map<String, Object>> readAppIconFile() {
        List list = (List)this.appIconApi.listAllIcon().getData();
        ArrayList iconList = new ArrayList();
        if (list != null) {
            for (AppIcon appicon : list) {
                HashMap<String, String> filemap = new HashMap<String, String>(16);
                filemap.put("path", appicon.getPath());
                filemap.put("name", appicon.getName());
                filemap.put("iconData", appicon.getIconData());
                iconList.add(filemap);
            }
        }
        HashMap map = new HashMap(16);
        map.put("iconList", iconList);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/save"})
    public Y9Result<SpmApproveItem> save(String itemJson) {
        SpmApproveItem item = (SpmApproveItem)Y9JsonUtil.readValue((String)itemJson, SpmApproveItem.class);
        return this.spmApproveItemService.save(item);
    }

    @PostMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(@RequestParam String[] idAndTabIndexs) {
        this.spmApproveItemService.updateOrder(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/searchAppIcon"})
    public Y9Result<Map<String, Object>> searchAppIcon(@RequestParam(required=false) String name) {
        List list = (List)this.appIconApi.searchAppIcon("%" + name + "%").getData();
        ArrayList iconList = new ArrayList();
        if (list != null) {
            for (AppIcon appicon : list) {
                HashMap<String, String> filemap = new HashMap<String, String>(16);
                filemap.put("path", appicon.getPath());
                filemap.put("name", appicon.getName());
                filemap.put("iconData", appicon.getIconData());
                iconList.add(filemap);
            }
        }
        HashMap map = new HashMap(16);
        map.put("iconList", iconList);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/uploadItemIcon"})
    public Y9Result<Map<String, Object>> uploadItemIcon(@RequestParam MultipartFile files) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("iconData", "");
        byte[] iconData = null;
        try {
            if (!files.isEmpty()) {
                iconData = files.getBytes();
                map.put("iconData", Base64.encodeToString((byte[])iconData));
            }
            return Y9Result.success(map, (String)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e1) {
            LOGGER.warn(e1.getMessage(), (Throwable)e1);
            return Y9Result.failure((String)"\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Generated
    public ItemRestController(SpmApproveItemService spmApproveItemService, RepositoryApi repositoryApi, OrganizationApi organizationApi, DepartmentApi departmentApi, AppIconApi appIconApi, OrgUnitApi orgUnitApi) {
        this.spmApproveItemService = spmApproveItemService;
        this.repositoryApi = repositoryApi;
        this.organizationApi = organizationApi;
        this.departmentApi = departmentApi;
        this.appIconApi = appIconApi;
        this.orgUnitApi = orgUnitApi;
    }
}

