/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.platform.dictionary.OptionValueApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.controller.vo.NodeTreeVO;
import net.risesoft.entity.DynamicRole;
import net.risesoft.enums.DynamicRoleKindsEnum;
import net.risesoft.model.platform.OptionValue;
import net.risesoft.model.platform.Role;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DynamicRoleService;
import net.risesoft.util.PackageClassFinder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/dynamicRole"}, produces={"application/json"})
public class DynamicRoleRestController {
    private final DynamicRoleService dynamicRoleService;
    private final OptionValueApi optionValueApi;
    private final RoleApi roleApi;

    @GetMapping(value={"/dynamicRoleList"})
    public Y9Result<List<DynamicRole>> dynamicRoleList() {
        List<DynamicRole> drList = this.dynamicRoleService.listAll();
        List dpcList = (List)this.optionValueApi.listByType(Y9LoginUserHolder.getTenantId(), "departmentPropCategory").getData();
        List roleList = (List)this.roleApi.listRoleByParentId("11111111-1111-1111-1111-111111111121").getData();
        drList.stream().filter(dynamicRole -> null != dynamicRole.getKinds()).forEach(dynamicRole -> {
            if (dynamicRole.getKinds().equals(DynamicRoleKindsEnum.DEPT_PROP_CATEGORY.getValue())) {
                List dpcListFilter = dpcList.stream().filter(dpc -> dpc.getCode().equals(String.valueOf(dynamicRole.getDeptPropCategory()))).collect(Collectors.toList());
                if (dpcListFilter.isEmpty()) {
                    dynamicRole.setDeptPropCategoryName("\u5df2\u5220\u9664");
                } else {
                    dynamicRole.setDeptPropCategoryName(((OptionValue)dpcListFilter.get(0)).getName());
                }
            } else if (dynamicRole.getKinds().equals(DynamicRoleKindsEnum.ROLE.getValue())) {
                List roleListFilter = roleList.stream().filter(role -> role.getId().equals(dynamicRole.getRoleId())).collect(Collectors.toList());
                if (roleListFilter.isEmpty()) {
                    dynamicRole.setRoleName("\u5df2\u5220\u9664");
                } else {
                    dynamicRole.setRoleName(((Role)roleListFilter.get(0)).getName());
                }
            }
        });
        return Y9Result.success(drList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getDynamicRole"})
    public Y9Result<DynamicRole> getDynamicRole(@RequestParam String id) {
        DynamicRole dynamicRole = this.dynamicRoleService.getById(id);
        return Y9Result.success((Object)dynamicRole, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/list"})
    public Y9Result<List<NodeTreeVO>> list() {
        ArrayList<NodeTreeVO> listMap = new ArrayList<NodeTreeVO>();
        List<DynamicRole> dynamicRoleList = this.dynamicRoleService.listAll();
        for (DynamicRole dynamicRole : dynamicRoleList) {
            NodeTreeVO map = new NodeTreeVO();
            map.setId(dynamicRole.getId());
            map.setName(dynamicRole.getName());
            map.setIsParent(false);
            map.setOrgType("dynamicRole");
            listMap.add(map);
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/deptPropCategory"})
    public Y9Result<List<OptionValue>> deptPropCategory() {
        return this.optionValueApi.listByType(Y9LoginUserHolder.getTenantId(), "departmentPropCategory");
    }

    @GetMapping(value={"/publicRole"})
    public Y9Result<List<Role>> publicRole() {
        return this.roleApi.listRoleByParentId("11111111-1111-1111-1111-111111111121");
    }

    @GetMapping(value={"/getClasses"})
    public Y9Result<List<String>> getClasses(String packageName) {
        try {
            List<Class<?>> classes = PackageClassFinder.getClasses(packageName);
            ArrayList<String> list = new ArrayList<String>();
            for (Class<?> clazz : classes) {
                list.add(clazz.getName());
            }
            return Y9Result.success(list, (String)"\u83b7\u53d6\u52a8\u6001\u89d2\u8272\u7c7b\u8def\u5f84\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Y9Result.failure((String)"\u83b7\u53d6\u52a8\u6001\u89d2\u8272\u7c7b\u8def\u5f84\u5931\u8d25");
        }
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String[] dynamicRoleIds) {
        this.dynamicRoleService.removeDynamicRoles(dynamicRoleIds);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(DynamicRole dynamicRole) {
        this.dynamicRoleService.saveOrUpdate(dynamicRole);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public DynamicRoleRestController(DynamicRoleService dynamicRoleService, OptionValueApi optionValueApi, RoleApi roleApi) {
        this.dynamicRoleService = dynamicRoleService;
        this.optionValueApi = optionValueApi;
        this.roleApi = roleApi;
    }
}

