/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.controller.vo.NodeTreeVO;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/department"}, produces={"application/json"})
public class DepartmentRestController {
    private final OrgUnitApi orgUnitApi;
    private final DepartmentApi departmentApi;
    private final OrganizationApi organizationApi;

    @GetMapping(value={"/findDeptAndUserById"})
    public Y9Result<List<NodeTreeVO>> findDeptAndUserById(@RequestParam(required=false) String id) {
        NodeTreeVO map;
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<NodeTreeVO> items = new ArrayList<NodeTreeVO>();
        if (StringUtils.isBlank((CharSequence)id)) {
            List list = (List)this.organizationApi.list(tenantId).getData();
            for (Organization orgUnit : list) {
                map = new NodeTreeVO();
                map.setId(orgUnit.getId());
                map.setParentId(orgUnit.getParentId());
                map.setName(orgUnit.getName());
                map.setOrgType(orgUnit.getOrgType().getValue());
                map.setIsParent(true);
                map.setNocheck(true);
                items.add(map);
            }
        }
        List employees = (List)this.orgUnitApi.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
        for (OrgUnit employee : employees) {
            map = new NodeTreeVO();
            map.setId(employee.getId());
            map.setParentId(employee.getParentId());
            map.setName(employee.getName());
            map.setOrgType(employee.getOrgType().getValue());
            map.setIsParent(false);
            map.setNocheck(false);
            items.add(map);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/findDeptById"})
    public Y9Result<List<NodeTreeVO>> findDeptById(@RequestParam(required=false) String id) {
        List<NodeTreeVO> items = this.findDeptById(id, false);
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public List<NodeTreeVO> findDeptById(String id, boolean isBureau) {
        NodeTreeVO node;
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<NodeTreeVO> items = new ArrayList<NodeTreeVO>();
        if (StringUtils.isBlank((CharSequence)id)) {
            List list = (List)this.organizationApi.list(tenantId).getData();
            for (Organization orgUnit : list) {
                node = new NodeTreeVO();
                node.setId(orgUnit.getId());
                node.setParentId(orgUnit.getParentId());
                node.setName(orgUnit.getName());
                node.setOrgType(orgUnit.getOrgType().getValue());
                node.setIsParent(true);
                node.setNocheck(true);
                items.add(node);
            }
        }
        List departments = (List)this.departmentApi.listByParentId(tenantId, id).getData();
        for (Department department : departments) {
            node = new NodeTreeVO();
            node.setId(department.getId());
            node.setParentId(department.getParentId());
            node.setName(department.getName());
            node.setOrgType(department.getOrgType().getValue());
            node.setNocheck(false);
            if (isBureau) {
                node.setIsParent(!department.isBureau());
            } else {
                node.setIsParent(!((List)this.departmentApi.listByParentId(tenantId, department.getId()).getData()).isEmpty());
            }
            items.add(node);
        }
        return items;
    }

    @GetMapping(value={"/getOrgList"})
    public Y9Result<List<Organization>> getOrgList() {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.organizationApi.list(tenantId).getData();
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrgTree"})
    public Y9Result<List<OrgUnit>> getOrgTree(String id, OrgTreeTypeEnum treeType) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.orgUnitApi.getSubTree(tenantId, id, treeType).getData();
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/searchDept"})
    public Y9Result<List<NodeTreeVO>> searchDept(@RequestParam(required=false) String name) {
        ArrayList<NodeTreeVO> items = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List employees = (List)this.orgUnitApi.treeSearch(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_DEPT).getData();
        for (OrgUnit employee : employees) {
            NodeTreeVO node = new NodeTreeVO();
            node.setId(employee.getId());
            node.setParentId(employee.getParentId());
            node.setName(employee.getName());
            node.setOrgType(employee.getOrgType().getValue());
            node.setIsParent(false);
            node.setNocheck(false);
            items.add(node);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/searchDeptAndPosition"})
    public Y9Result<List<NodeTreeVO>> searchDeptAndPosition(@RequestParam(required=false) String name) {
        ArrayList<NodeTreeVO> items = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List employees = (List)this.orgUnitApi.treeSearch(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_ORG_POSITION).getData();
        for (OrgUnit employee : employees) {
            NodeTreeVO node = new NodeTreeVO();
            node.setId(employee.getId());
            node.setParentId(employee.getParentId());
            node.setName(employee.getName());
            node.setOrgType(employee.getOrgType().getValue());
            node.setIsParent(false);
            node.setNocheck(false);
            items.add(node);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/treeSearch"})
    public Y9Result<List<OrgUnit>> treeSearch(String name, OrgTreeTypeEnum treeType) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.orgUnitApi.treeSearch(tenantId, name, treeType).getData();
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @Generated
    public DepartmentRestController(OrgUnitApi orgUnitApi, DepartmentApi departmentApi, OrganizationApi organizationApi) {
        this.orgUnitApi = orgUnitApi;
        this.departmentApi = departmentApi;
        this.organizationApi = organizationApi;
    }
}

