/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.HistoricActivityApi;
import net.risesoft.api.processadmin.HistoricVariableApi;
import net.risesoft.entity.Opinion;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.HistoricActivityInstanceModel;
import net.risesoft.model.processadmin.HistoricVariableInstanceModel;
import net.risesoft.nosql.elastic.entity.OfficeDoneInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.OpinionRepository;
import net.risesoft.service.OfficeDoneInfoService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/bpmnViewer"}, produces={"application/json"})
public class BpmnViewerRestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnViewerRestController.class);
    private final HistoricActivityApi historicActivityApi;
    private final OfficeDoneInfoService officeDoneInfoService;
    private final OpinionRepository opinionRepository;
    private final OrgUnitApi orgUnitApi;
    private final HistoricVariableApi historicVariableApi;

    @GetMapping(value={"/getTaskList"})
    public Y9Result<List<HistoricActivityInstanceModel>> getTaskList(@RequestParam String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = new ArrayList();
        try {
            list = (List)this.historicActivityApi.getByProcessInstanceIdAndYear(tenantId, processInstanceId, "").getData();
            String year = "";
            if (list == null || list.isEmpty()) {
                OfficeDoneInfo info = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
                year = info.getStartTime().substring(0, 4);
                list = (List)this.historicActivityApi.getByProcessInstanceIdAndYear(tenantId, processInstanceId, year).getData();
            }
            for (HistoricActivityInstanceModel task : list) {
                String assignee = task.getAssignee();
                task.setExecutionId("");
                if (assignee == null) continue;
                List opinion = this.opinionRepository.findByTaskIdAndPositionIdAndProcessTrackIdIsNull(task.getTaskId(), StringUtils.isBlank((CharSequence)assignee) ? "" : assignee);
                OrgUnit employee = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
                HistoricVariableInstanceModel zhuBan = null;
                try {
                    zhuBan = (HistoricVariableInstanceModel)this.historicVariableApi.getByTaskIdAndVariableName(tenantId, task.getTaskId(), "parallelSponsor", year).getData();
                }
                catch (Exception e) {
                    LOGGER.error("\u83b7\u53d6\u4e3b\u529e\u4eba\u5931\u8d25", (Throwable)e);
                }
                String employeeName = "";
                if (employee != null) {
                    employeeName = employee.getName();
                }
                if (StringUtils.isNotBlank((CharSequence)task.getTenantId())) {
                    employeeName = task.getTenantId();
                }
                task.setTenantId(!opinion.isEmpty() ? ((Opinion)opinion.get(0)).getContent() : "");
                if (zhuBan != null) {
                    task.setCalledProcessInstanceId(employeeName + "(\u4e3b\u529e)");
                } else {
                    task.setCalledProcessInstanceId(employeeName);
                }
                if (task.getStartTime() == null || task.getEndTime() == null) continue;
                task.setExecutionId(this.longTime(task.getStartTime(), task.getEndTime()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8282\u70b9\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    private String longTime(Date startTime, Date endTime) {
        if (endTime == null) {
            return "";
        }
        long time = endTime.getTime() - startTime.getTime();
        int s = (int)((time /= 1000L) % 60L);
        int m = (int)(time / 60L % 60L);
        int h = (int)(time / 3600L % 24L);
        int d = (int)(time / 86400L);
        return d + "\u5929" + h + "\u5c0f\u65f6" + m + "\u5206" + s + "\u79d2";
    }

    @Generated
    public BpmnViewerRestController(HistoricActivityApi historicActivityApi, OfficeDoneInfoService officeDoneInfoService, OpinionRepository opinionRepository, OrgUnitApi orgUnitApi, HistoricVariableApi historicVariableApi) {
        this.historicActivityApi = historicActivityApi;
        this.officeDoneInfoService = officeDoneInfoService;
        this.opinionRepository = opinionRepository;
        this.orgUnitApi = orgUnitApi;
        this.historicVariableApi = historicVariableApi;
    }
}

