/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import lombok.Generated;
import net.risesoft.api.itemadmin.WordTemplateApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.entity.ItemWordTemplateBind;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.WordTemplate;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemWordTemplateBindRepository;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.WordTemplateService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/wordTemplate"}, produces={"application/json"})
public class WordTemplateApiImpl
implements WordTemplateApi {
    private final WordTemplateService wordTemplateService;
    private final SpmApproveItemService spmApproveItemService;
    private final ItemWordTemplateBindRepository itemWordTemplateBindRepository;
    private final RepositoryApi repositoryApi;

    public Y9Result<String> getFilePathById(@RequestParam String tenantId, @RequestParam String id) {
        String y9FilePathId = "";
        Y9LoginUserHolder.setTenantId((String)tenantId);
        WordTemplate wordTemplate = this.wordTemplateService.findById(id);
        if (null != wordTemplate) {
            y9FilePathId = wordTemplate.getFilePath();
        }
        return Y9Result.success((Object)y9FilePathId);
    }

    public Y9Result<String> getWordTemplateBind(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String wordType) {
        WordTemplate wordTemplate;
        String y9FilePathId = null;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefinitionKey = item.getWorkflowGuid();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
        String processDefinitionId = processDefinition.getId();
        ItemWordTemplateBind bind = this.itemWordTemplateBindRepository.findByItemIdAndProcessDefinitionIdAndBindValue(itemId, processDefinitionId, wordType);
        if (null != bind && null != (wordTemplate = this.wordTemplateService.findById(bind.getTemplateId()))) {
            y9FilePathId = wordTemplate.getFilePath();
        }
        return Y9Result.success(y9FilePathId);
    }

    @Generated
    public WordTemplateApiImpl(WordTemplateService wordTemplateService, SpmApproveItemService spmApproveItemService, ItemWordTemplateBindRepository itemWordTemplateBindRepository, RepositoryApi repositoryApi) {
        this.wordTemplateService = wordTemplateService;
        this.spmApproveItemService = spmApproveItemService;
        this.itemWordTemplateBindRepository = itemWordTemplateBindRepository;
        this.repositoryApi = repositoryApi;
    }
}

