/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.UrgeInfoApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.UrgeInfo;
import net.risesoft.model.itemadmin.UrgeInfoModel;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.UrgeInfoService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/urgeInfo"}, produces={"application/json"})
public class UrgeInfoApiImpl
implements UrgeInfoApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UrgeInfoApiImpl.class);
    private final PersonApi personApi;
    private final UrgeInfoService urgeInfoService;

    public Y9Result<Object> save(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, @RequestParam String msgContent) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)((Person)this.personApi.get(tenantId, userId).getData()));
        this.urgeInfoService.save(processSerialNumber, msgContent);
        return Y9Result.success();
    }

    public Y9Result<List<UrgeInfoModel>> findByProcessSerialNumber(String tenantId, String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<UrgeInfo> urgeInfoList = this.urgeInfoService.findByProcessSerialNumber(processSerialNumber);
        ArrayList modelList = new ArrayList();
        urgeInfoList.forEach(urgeInfo -> {
            UrgeInfoModel urgeInfoModel = new UrgeInfoModel();
            Y9BeanUtil.copyProperties((Object)urgeInfo, (Object)urgeInfoModel);
            modelList.add(urgeInfoModel);
        });
        return Y9Result.success(modelList);
    }

    public Y9Result<Object> deleteById(String tenantId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.urgeInfoService.deleteById(id);
        return Y9Result.success();
    }

    @Generated
    public UrgeInfoApiImpl(PersonApi personApi, UrgeInfoService urgeInfoService) {
        this.personApi = personApi;
        this.urgeInfoService = urgeInfoService;
    }
}

