/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jodd.util.Base64;
import lombok.Generated;
import net.risesoft.api.itemadmin.TransactionWordApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.entity.ItemWordTemplateBind;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.TaoHongTemplate;
import net.risesoft.entity.TransactionHistoryWord;
import net.risesoft.entity.TransactionWord;
import net.risesoft.entity.WordTemplate;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.enums.ItemWordTypeEnum;
import net.risesoft.model.itemadmin.TaoHongTemplateModel;
import net.risesoft.model.itemadmin.TransactionHistoryWordModel;
import net.risesoft.model.itemadmin.TransactionWordModel;
import net.risesoft.model.itemadmin.Y9WordInfo;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemWordTemplateBindRepository;
import net.risesoft.repository.jpa.TransactionHistoryWordRepository;
import net.risesoft.repository.jpa.TransactionWordRepository;
import net.risesoft.repository.jpa.WordTemplateRepository;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.TaoHongTemplateService;
import net.risesoft.service.TransactionHistoryWordService;
import net.risesoft.service.TransactionWordService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/transactionWord"}, produces={"application/json"})
public class TransactionWordApiImpl
implements TransactionWordApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionWordApiImpl.class);
    private final TransactionWordRepository transactionWordRepository;
    private final TransactionWordService transactionWordService;
    private final TransactionHistoryWordService transactionHistoryWordService;
    private final TransactionHistoryWordRepository transactionHistoryWordRepository;
    private final TaoHongTemplateService taoHongTemplateService;
    private final WordTemplateRepository wordTemplateRepository;
    private final ItemWordTemplateBindRepository wordTemplateBindRepository;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitApi;
    private final Y9FileStoreService y9FileStoreService;
    private final TaskApi taskApi;
    private final SpmApproveItemService spmApproveItemService;
    private final RepositoryApi repositoryApi;

    public Y9Result<Object> delBatchByProcessSerialNumbers(@RequestParam String tenantId, @RequestBody List<String> processSerialNumbers) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.transactionWordService.delBatchByProcessSerialNumbers(processSerialNumbers);
        this.transactionHistoryWordService.delBatchByProcessSerialNumbers(processSerialNumbers);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteByIsTaoHong(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, @RequestParam String isTaoHong) {
        List<Object> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)processSerialNumber) && StringUtils.isNotBlank((CharSequence)isTaoHong)) {
            list = this.transactionWordService.listByProcessSerialNumberAndIstaohong(processSerialNumber, isTaoHong);
        }
        for (TransactionWord transactionWord : list) {
            this.transactionWordRepository.delete((Object)transactionWord);
            try {
                this.y9FileStoreService.deleteFile(transactionWord.getFileStoreId());
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
        if (ItemWordTypeEnum.PDF1.getValue().equals(isTaoHong)) {
            this.transactionHistoryWordService.deleteHistoryWordByIsTaoHong(processSerialNumber, "3");
        }
        return Y9Result.success();
    }

    public Y9Result<TransactionWordModel> exchangeFindWordByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber) {
        TransactionWordModel word = new TransactionWordModel();
        try {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            Person person = (Person)this.personApi.get(tenantId, userId).getData();
            Y9LoginUserHolder.setPerson((Person)person);
            List<TransactionWord> list = this.transactionWordService.listByProcessSerialNumber(processSerialNumber);
            if (list != null && !list.isEmpty()) {
                TransactionWord transactionWord = list.get(0);
                Person user = (Person)this.personApi.get(tenantId, transactionWord.getUserId()).getData();
                word = this.getTransactionWord(transactionWord);
                word.setFileName(transactionWord.getTitle() + transactionWord.getFileType());
                word.setUserName(user.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6b63\u6587\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u6b63\u6587\u6587\u4ef6\u4fe1\u606f\u5931\u8d25");
        }
        return Y9Result.success((Object)word);
    }

    public Y9Result<TransactionHistoryWordModel> findHistoryVersionDoc(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<TransactionHistoryWord> historyWordList = this.transactionHistoryWordService.listByTaskId(taskId);
        TransactionHistoryWordModel history = new TransactionHistoryWordModel();
        if (null != historyWordList && !historyWordList.isEmpty()) {
            TransactionHistoryWord historyWord = historyWordList.get(0);
            if (StringUtils.isNotEmpty((CharSequence)historyWord.getIstaohong())) {
                if (ItemWordTypeEnum.PDF.getValue().equals(historyWord.getIstaohong()) || ItemWordTypeEnum.PDF1.getValue().equals(historyWord.getIstaohong()) || ItemWordTypeEnum.PDF2.getValue().equals(historyWord.getIstaohong())) {
                    history.setOpenWordOrPdf("openPDF");
                } else if (ItemWordTypeEnum.WORD.getValue().equals(historyWord.getIstaohong()) || ItemWordTypeEnum.REDHEADWORD.getValue().equals(historyWord.getIstaohong())) {
                    history.setOpenWordOrPdf("openWord");
                }
            } else {
                history.setOpenWordOrPdf("openWord");
            }
            history.setTitle(historyWord.getTitle());
            history.setFileSize(historyWord.getFileSize());
            history.setId(historyWord.getId());
            history.setProcessSerialNumber(historyWord.getProcessSerialNumber());
            history.setSaveDate(historyWord.getSaveDate());
            history.setFileStoreId(historyWord.getFileStoreId());
            history.setFileType(historyWord.getFileType());
            history.setIsTaoHong(StringUtils.isNotBlank((CharSequence)historyWord.getIstaohong()) ? historyWord.getIstaohong() : "");
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, historyWord.getUserId()).getData();
            history.setUserName(orgUnit != null && StringUtils.isNotBlank((CharSequence)orgUnit.getId()) ? orgUnit.getName() : "");
            history.setUserId(historyWord.getUserId());
        }
        return Y9Result.success((Object)history);
    }

    public Y9Result<TransactionWordModel> findWordByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        TransactionWordModel word = new TransactionWordModel();
        try {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            List<TransactionWord> list = this.transactionWordService.listByProcessSerialNumber(processSerialNumber);
            if (list != null && !list.isEmpty()) {
                TransactionWord transactionWord = list.get(0);
                word = this.getTransactionWord(transactionWord);
                word.setFileName(transactionWord.getTitle() + transactionWord.getFileType());
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, transactionWord.getUserId()).getData();
                word.setUserName(orgUnit.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6b63\u6587\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u6b63\u6587\u6587\u4ef6\u4fe1\u606f\u5931\u8d25");
        }
        return Y9Result.success((Object)word);
    }

    private TransactionWordModel getTransactionWord(TransactionWord transactionWord) {
        TransactionWordModel wordModel = new TransactionWordModel();
        wordModel.setId(transactionWord.getId());
        wordModel.setTitle(transactionWord.getTitle());
        wordModel.setFileStoreId(transactionWord.getFileStoreId());
        wordModel.setFileSize(transactionWord.getFileSize());
        wordModel.setFileName(transactionWord.getFileName());
        wordModel.setProcessSerialNumber(transactionWord.getProcessSerialNumber());
        wordModel.setSaveDate(transactionWord.getSaveDate());
        wordModel.setUserId(transactionWord.getUserId());
        wordModel.setIsTaoHong(transactionWord.getIstaohong());
        wordModel.setFileType(transactionWord.getFileType());
        return wordModel;
    }

    public Y9Result<List<TransactionWordModel>> getWordList(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber) {
        ArrayList<TransactionWordModel> retList = new ArrayList<TransactionWordModel>();
        try {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            Person person = (Person)this.personApi.get(tenantId, userId).getData();
            Y9LoginUserHolder.setPerson((Person)person);
            List list = this.transactionWordRepository.findByProcessSerialNumber(processSerialNumber);
            for (TransactionWord word : list) {
                TransactionWordModel model = this.getTransactionWord(word);
                retList.add(model);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6b63\u6587\u5217\u8868\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u6b63\u6587\u5217\u8868\u5931\u8d25");
        }
        return Y9Result.success(retList);
    }

    public Y9Result<String> openDocument(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, @RequestParam String itemId, String bindValue) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<Object> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)processSerialNumber)) {
            list = StringUtils.isNotBlank((CharSequence)bindValue) && !"null".equals(bindValue) ? this.transactionWordService.listByProcessSerialNumberAndDocCategory(processSerialNumber, bindValue) : this.transactionWordService.listByProcessSerialNumber(processSerialNumber);
        }
        if (!list.isEmpty()) {
            TransactionWord transactionWord = (TransactionWord)list.get(0);
            if (StringUtils.isNotBlank((CharSequence)transactionWord.getFileStoreId())) {
                return Y9Result.success((Object)transactionWord.getFileStoreId());
            }
            LOGGER.error("fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
            return Y9Result.failure((String)"fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
        }
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefinitionKey = item.getWorkflowGuid();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
        String processDefinitionId = processDefinition.getId();
        if (StringUtils.isNotBlank((CharSequence)bindValue)) {
            ItemWordTemplateBind wordTemplateBind = this.wordTemplateBindRepository.findByItemIdAndProcessDefinitionIdAndBindValue(itemId, processDefinitionId, bindValue);
            WordTemplate wordTemplate = this.wordTemplateRepository.findById((Object)(wordTemplateBind != null ? wordTemplateBind.getTemplateId() : "")).orElse(null);
            if (wordTemplate != null && wordTemplate.getId() != null) {
                return Y9Result.success((Object)wordTemplate.getFilePath());
            }
            LOGGER.error("\u6570\u636e\u5e93\u6ca1\u6709processSerialNumber=" + processSerialNumber + "\u548cbindVvalue=" + bindValue + "\u7ed1\u5b9a\u7684\u6b63\u6587\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return Y9Result.failure((String)("\u6570\u636e\u5e93\u6ca1\u6709processSerialNumber=" + processSerialNumber + "\u548cbindVvalue=" + bindValue + "\u7ed1\u5b9a\u7684\u6b63\u6587\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        ItemWordTemplateBind wordTemplateBind = this.wordTemplateBindRepository.findByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
        WordTemplate wordTemplate = this.wordTemplateRepository.findById((Object)(wordTemplateBind != null ? wordTemplateBind.getTemplateId() : "")).orElse(null);
        if (wordTemplate != null && wordTemplate.getId() != null) {
            return Y9Result.success((Object)wordTemplate.getFilePath());
        }
        LOGGER.error("\u6570\u636e\u5e93\u6ca1\u6709processSerialNumber=" + processSerialNumber + "\u7684\u6b63\u6587\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return Y9Result.failure((String)("\u6570\u636e\u5e93\u6ca1\u6709processSerialNumber=" + processSerialNumber + "\u7684\u6b63\u6587\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
    }

    public Y9Result<String> openDocumentByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<TransactionWord> list = this.transactionWordService.listByProcessSerialNumberAndIstaohong(processSerialNumber, "1");
        if (list.isEmpty()) {
            list = this.transactionWordService.listByProcessSerialNumberAndIstaohong(processSerialNumber, "0");
        }
        if (!list.isEmpty()) {
            TransactionWord transactionWord = list.get(0);
            if (StringUtils.isNotBlank((CharSequence)transactionWord.getFileStoreId())) {
                return Y9Result.success((Object)transactionWord.getFileStoreId());
            }
            LOGGER.error("fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
            return Y9Result.failure((String)"fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
        }
        return Y9Result.failure((String)"\u672a\u627e\u5230\u6587\u6863\u4fe1\u606f");
    }

    public Y9Result<String> openDocumentTemplate(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String templateGuid) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        LOGGER.debug("call /ntko/openTaohongTemplate");
        TaoHongTemplate taohongTemplate = this.taoHongTemplateService.getById(templateGuid);
        if (null != taohongTemplate) {
            byte[] buf = taohongTemplate.getTemplateContent();
            if (buf != null) {
                try {
                    return Y9Result.success((Object)Base64.encodeToString((byte[])buf));
                }
                catch (Exception e) {
                    LOGGER.error("\u5411jsp\u9875\u9762\u8f93\u51faword\u4e8c\u8fdb\u5236\u6d41\u9519\u8bef", (Throwable)e);
                    return Y9Result.failure((String)"\u5411jsp\u9875\u9762\u8f93\u51faword\u4e8c\u8fdb\u5236\u6d41\u9519\u8bef! ");
                }
            }
        } else {
            LOGGER.error("\u6570\u636e\u5e93\u6ca1\u6709templateGUID=" + templateGuid + "\u7684\u6a21\u7248\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return Y9Result.failure((String)("\u6570\u636e\u5e93\u6ca1\u6709templateGUID=" + templateGuid + "\u7684\u6a21\u7248\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return Y9Result.failure((String)"\u672a\u627e\u5230\u6587\u6863\u4fe1\u606f");
    }

    @Deprecated
    public Y9Result<Object> openHistoryVersionDoc(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId) {
        return Y9Result.success();
    }

    public Y9Result<String> openPdf(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<Object> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)processSerialNumber)) {
            list = this.transactionWordService.listByProcessSerialNumber(processSerialNumber);
        }
        if (!list.isEmpty()) {
            TransactionWord transactionWord = (TransactionWord)list.get(0);
            if (StringUtils.isNotBlank((CharSequence)transactionWord.getFileStoreId())) {
                return Y9Result.success((Object)transactionWord.getFileStoreId());
            }
            LOGGER.error("fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
            return Y9Result.failure((String)"fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
        }
        return Y9Result.failure((String)"\u672a\u627e\u5230\u6587\u6863\u4fe1\u606f");
    }

    public Y9Result<String> openRevokePdfAfterDocument(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, @RequestParam String isTaoHong) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<Object> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)processSerialNumber) && StringUtils.isNotBlank((CharSequence)isTaoHong)) {
            list = this.transactionWordService.listByProcessSerialNumberAndIstaohong(processSerialNumber, isTaoHong);
        }
        if (!list.isEmpty()) {
            TransactionWord transactionWord = (TransactionWord)list.get(0);
            if (StringUtils.isNotBlank((CharSequence)transactionWord.getFileStoreId())) {
                return Y9Result.success((Object)transactionWord.getFileStoreId());
            }
            LOGGER.error("fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
            return Y9Result.failure((String)"fileStoreId\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6b63\u6587\u7684\u65f6\u5019\u51fa\u9519");
        }
        return Y9Result.failure((String)"\u672a\u627e\u5230\u6587\u6863\u4fe1\u606f");
    }

    public Y9Result<String> openTaoHong(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String activitiUser) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        LOGGER.debug("call /ntko/openTaoHong");
        OrgUnit currentBureau = (OrgUnit)this.orgUnitApi.getBureau(Y9LoginUserHolder.getTenantId(), activitiUser).getData();
        return Y9Result.success((Object)currentBureau.getId());
    }

    public Y9Result<Boolean> saveImportTransationWord(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String docjson, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        boolean checkSave = false;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map documentMap = (Map)Y9JsonUtil.readValue((String)docjson, Map.class);
            assert (documentMap != null);
            List documentList = (List)documentMap.get("document");
            for (Map dMap : documentList) {
                TransactionWord tw = new TransactionWord();
                tw.setId(dMap.get("id").toString());
                tw.setFileName(dMap.get("fileName").toString());
                tw.setFileStoreId(dMap.get("filePath").toString());
                tw.setFileType(dMap.get("fileType").toString());
                tw.setProcessSerialNumber(processSerialNumber);
                tw.setSaveDate(sdf.format(new Date()));
                tw.setTenantId(dMap.get("tenantId").toString());
                tw.setUserId(dMap.get("userId").toString());
                tw.setTitle(dMap.get("title") == null ? "" : dMap.get("title").toString());
                this.transactionWordService.save(tw);
                checkSave = true;
            }
            return Y9Result.success((Object)checkSave);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u516c\u6587\u4f20\u8f93\u8f6c\u5165\u5de5\u4f5c\u6d41\u7684\u6b63\u6587\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u516c\u6587\u4f20\u8f93\u8f6c\u5165\u5de5\u4f5c\u6d41\u7684\u6b63\u6587\u4fe1\u606f\u5931\u8d25");
        }
    }

    public Y9Result<Y9WordInfo> showWord(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, @RequestParam String itemId, String itembox, String taskId, String bindValue) {
        Y9WordInfo retMap = new Y9WordInfo();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        String fileDocumentId = "";
        String wordReadOnly = "";
        String openWordOrPdf = "";
        String isTaoHong = "0";
        String docCategory = "";
        String fileType = ".doc";
        if ("".equals(itembox) || itembox.equalsIgnoreCase(ItemBoxTypeEnum.ADD.getValue()) || itembox.equalsIgnoreCase(ItemBoxTypeEnum.TODO.getValue()) || itembox.equalsIgnoreCase(ItemBoxTypeEnum.DRAFT.getValue())) {
            wordReadOnly = "NO";
        } else if (itembox.equalsIgnoreCase(ItemBoxTypeEnum.DONE.getValue()) || itembox.equalsIgnoreCase(ItemBoxTypeEnum.DOING.getValue())) {
            wordReadOnly = "YES";
        }
        String saveDate = "";
        List<Object> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)processSerialNumber)) {
            list = StringUtils.isNotBlank((CharSequence)bindValue) ? this.transactionWordService.listByProcessSerialNumberAndDocCategory(processSerialNumber, bindValue) : this.transactionWordService.listByProcessSerialNumber(processSerialNumber);
        }
        if (list != null && !list.isEmpty()) {
            TransactionWord d = (TransactionWord)list.get(0);
            fileDocumentId = d.getId();
            saveDate = d.getSaveDate();
            if (d.getIstaohong().equals(ItemWordTypeEnum.PDF2.getValue())) {
                openWordOrPdf = "openWordToPDF";
                isTaoHong = "4";
            } else if (d.getIstaohong().equals(ItemWordTypeEnum.PDF1.getValue())) {
                openWordOrPdf = "openWordToPDF";
                isTaoHong = "3";
            } else if (d.getIstaohong().equals(ItemWordTypeEnum.PDF.getValue())) {
                openWordOrPdf = "openPDF";
                isTaoHong = "2";
            } else if (d.getIstaohong().equals(ItemWordTypeEnum.REDHEADWORD.getValue())) {
                openWordOrPdf = "openTaoHongWord";
                isTaoHong = "1";
            } else {
                openWordOrPdf = "openWord";
                isTaoHong = "0";
            }
            retMap.setFileType(d.getFileType());
            retMap.setFileStoreId(d.getFileStoreId());
            retMap.setUid(d.getFileStoreId());
        } else {
            String fileName;
            WordTemplate wordTemplate;
            ItemWordTemplateBind wordTemplateBind;
            String processDefinitionId;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskId})) {
                TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
                processDefinitionId = task.getProcessDefinitionId();
            } else {
                SpmApproveItem item = this.spmApproveItemService.findById(itemId);
                String processDefinitionKey = item.getWorkflowGuid();
                ProcessDefinitionModel processDefinitionModel = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
                processDefinitionId = processDefinitionModel.getId();
            }
            if (StringUtils.isNotBlank((CharSequence)bindValue)) {
                wordTemplateBind = this.wordTemplateBindRepository.findByItemIdAndProcessDefinitionIdAndBindValue(itemId, processDefinitionId, bindValue);
                wordTemplate = this.wordTemplateRepository.findById((Object)(wordTemplateBind != null ? wordTemplateBind.getTemplateId() : "")).orElse(null);
                if (wordTemplate != null && wordTemplate.getId() != null) {
                    fileDocumentId = wordTemplate.getId();
                    openWordOrPdf = "openWordTemplate";
                    fileName = wordTemplate.getFileName();
                    fileType = fileName.substring(fileName.lastIndexOf("."));
                } else {
                    openWordOrPdf = "openWord";
                    docCategory = bindValue;
                }
            } else {
                wordTemplateBind = this.wordTemplateBindRepository.findByItemIdAndProcessDefinitionId(itemId, processDefinitionId);
                wordTemplate = this.wordTemplateRepository.findById((Object)(wordTemplateBind != null ? wordTemplateBind.getTemplateId() : "")).orElse(null);
                if (wordTemplate != null && wordTemplate.getId() != null) {
                    fileDocumentId = wordTemplate.getId();
                    openWordOrPdf = "openWordTemplate";
                    fileName = wordTemplate.getFileName();
                    fileType = fileName.substring(fileName.lastIndexOf("."));
                }
            }
        }
        String activitiUser = person.getId();
        retMap.setFileType(fileType);
        retMap.setDocCategory(docCategory);
        retMap.setActivitiUser(activitiUser);
        retMap.setFileDocumentId(fileDocumentId);
        retMap.setProcessSerialNumber(processSerialNumber);
        retMap.setUserName(person.getName());
        retMap.setSaveDate(saveDate);
        retMap.setOpenWordOrPdf(openWordOrPdf);
        retMap.setWordReadOnly(wordReadOnly);
        retMap.setItemId(itemId);
        retMap.setItembox(itembox);
        retMap.setTaskId(taskId);
        retMap.setIsTaoHong(isTaoHong);
        return Y9Result.success((Object)retMap);
    }

    public Y9Result<List<TaoHongTemplateModel>> taoHongTemplateList(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String currentBureauGuid) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        LOGGER.debug("call /ntko/list");
        ArrayList<TaoHongTemplateModel> retList = new ArrayList<TaoHongTemplateModel>();
        List<TaoHongTemplate> list = this.taoHongTemplateService.listByBureauGuid(currentBureauGuid);
        if (list.isEmpty()) {
            TaoHongTemplateModel taohong = new TaoHongTemplateModel();
            taohong.setHasDocumentTemplate("0");
            retList.add(taohong);
        } else {
            for (TaoHongTemplate taoHongTemplate : list) {
                TaoHongTemplateModel taohong = new TaoHongTemplateModel();
                taohong.setHasDocumentTemplate("1");
                taohong.setTemplateGuid(taoHongTemplate.getTemplateGuid());
                taohong.setTemplateFileName(taoHongTemplate.getTemplateFileName());
                taohong.setTemplateType(taoHongTemplate.getTemplateType());
                retList.add(taohong);
            }
        }
        return Y9Result.success(retList);
    }

    @PostMapping(value={"/uploadWord"})
    public Y9Result<Boolean> uploadWord(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String documentTitle, @RequestParam String fileType, @RequestParam String processSerialNumber, String isTaoHong, String docCategory, String taskId, String fileSizeString, @RequestParam String fileStoreId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        try {
            if (StringUtils.isNotBlank((CharSequence)processSerialNumber)) {
                List<TransactionWord> list = this.transactionWordService.listByProcessSerialNumberAndIstaohong(processSerialNumber, isTaoHong);
                if (list.isEmpty()) {
                    this.transactionWordService.saveTransactionWord(fileStoreId, fileSizeString, documentTitle, fileType, processSerialNumber, isTaoHong, docCategory);
                    this.transactionHistoryWordService.saveTransactionHistoryWord(fileStoreId, fileSizeString, documentTitle, fileType, processSerialNumber, isTaoHong, taskId, docCategory);
                } else {
                    documentTitle = StringUtils.isNotEmpty((CharSequence)list.get(0).getTitle()) ? list.get(0).getTitle() : "\u6b63\u6587";
                    this.transactionWordService.updateTransactionWordById(fileStoreId, fileType, documentTitle + fileType, fileSizeString, isTaoHong, userId, list.get(0).getId());
                    List thwlist = StringUtils.isNotBlank((CharSequence)taskId) ? this.transactionHistoryWordRepository.getByProcessSerialNumberAndIsTaoHongAndTaskId(processSerialNumber, isTaoHong, taskId) : this.transactionHistoryWordRepository.findByProcessSerialNumber(processSerialNumber);
                    if (thwlist.isEmpty()) {
                        this.transactionHistoryWordService.saveTransactionHistoryWord(fileStoreId, fileSizeString, documentTitle, fileType, processSerialNumber, isTaoHong, taskId, docCategory);
                    } else {
                        this.transactionHistoryWordService.updateTransactionHistoryWordById(fileStoreId, fileType, documentTitle + fileType, fileSizeString, isTaoHong, docCategory, userId, ((TransactionHistoryWord)thwlist.get(0)).getId());
                    }
                }
                return Y9Result.success((Object)true);
            }
            return Y9Result.success((Object)false);
        }
        catch (Exception e) {
            LOGGER.error("\u8349\u7a3f\u7bb1\u4fdd\u5b58\u6b63\u6587\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u8349\u7a3f\u7bb1\u4fdd\u5b58\u6b63\u6587\u5931\u8d25");
        }
    }

    public Y9Result<TransactionWordModel> wordDownload(@RequestParam String tenantId, @RequestParam String id) {
        TransactionWord transactionWord = this.transactionWordRepository.findById((Object)id).orElse(null);
        assert (transactionWord != null);
        TransactionWordModel model = this.getTransactionWord(transactionWord);
        return Y9Result.success((Object)model);
    }

    @Generated
    public TransactionWordApiImpl(TransactionWordRepository transactionWordRepository, TransactionWordService transactionWordService, TransactionHistoryWordService transactionHistoryWordService, TransactionHistoryWordRepository transactionHistoryWordRepository, TaoHongTemplateService taoHongTemplateService, WordTemplateRepository wordTemplateRepository, ItemWordTemplateBindRepository wordTemplateBindRepository, PersonApi personApi, OrgUnitApi orgUnitApi, Y9FileStoreService y9FileStoreService, TaskApi taskApi, SpmApproveItemService spmApproveItemService, RepositoryApi repositoryApi) {
        this.transactionWordRepository = transactionWordRepository;
        this.transactionWordService = transactionWordService;
        this.transactionHistoryWordService = transactionHistoryWordService;
        this.transactionHistoryWordRepository = transactionHistoryWordRepository;
        this.taoHongTemplateService = taoHongTemplateService;
        this.wordTemplateRepository = wordTemplateRepository;
        this.wordTemplateBindRepository = wordTemplateBindRepository;
        this.personApi = personApi;
        this.orgUnitApi = orgUnitApi;
        this.y9FileStoreService = y9FileStoreService;
        this.taskApi = taskApi;
        this.spmApproveItemService = spmApproveItemService;
        this.repositoryApi = repositoryApi;
    }
}

