/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.SpeakInfoApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.SpeakInfo;
import net.risesoft.model.itemadmin.SpeakInfoModel;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SpeakInfoService;
import net.risesoft.util.ItemAdminModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/speakInfo"}, produces={"application/json"})
public class SpeakInfoApiImpl
implements SpeakInfoApi {
    private final SpeakInfoService speakInfoService;
    private final PersonApi personApi;

    public Y9Result<Object> deleteById(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.speakInfoService.deleteById(id);
    }

    public Y9Result<SpeakInfoModel> findById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SpeakInfo speakInfo = this.speakInfoService.findById(id);
        SpeakInfoModel speakInfoModel = null;
        if (speakInfo != null) {
            speakInfoModel = new SpeakInfoModel();
            Y9BeanUtil.copyProperties((Object)speakInfo, (Object)speakInfoModel);
        }
        return Y9Result.success(speakInfoModel);
    }

    public Y9Result<List<SpeakInfoModel>> findByProcessInstanceId(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processInstanceId) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        List<SpeakInfo> siList = this.speakInfoService.findByProcessInstanceId(processInstanceId);
        return Y9Result.success(ItemAdminModelConvertUtil.speakInfoList2ModelList(siList));
    }

    public Y9Result<Integer> getNotReadCount(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.speakInfoService.getNotReadCount(processInstanceId, userId));
    }

    public Y9Result<String> saveOrUpdate(@RequestParam String tenantId, @RequestParam String userId, @RequestBody SpeakInfoModel speakInfoModel) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        SpeakInfo speakInfo = new SpeakInfo();
        Y9BeanUtil.copyProperties((Object)speakInfoModel, (Object)speakInfo);
        return Y9Result.success((Object)this.speakInfoService.saveOrUpdate(speakInfo));
    }

    @Generated
    public SpeakInfoApiImpl(SpeakInfoService speakInfoService, PersonApi personApi) {
        this.speakInfoService = speakInfoService;
        this.personApi = personApi;
    }
}

