/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.SignDeptInfoApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.SignDeptInfo;
import net.risesoft.entity.SignOutDept;
import net.risesoft.entity.SignOutDeptType;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.SignDeptModel;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.SignOutDeptRepository;
import net.risesoft.repository.jpa.SignOutDeptTypeRepository;
import net.risesoft.service.SignDeptInfoService;
import net.risesoft.service.SignDeptOutService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/signDept"}, produces={"application/json"})
public class SignDeptInfoApiImpl
implements SignDeptInfoApi {
    private final SignDeptInfoService signDeptInfoService;
    private final OrgUnitApi orgUnitApi;
    private final SignDeptOutService signDeptOutService;
    private final SignOutDeptTypeRepository signOutDeptTypeRepository;
    private final SignOutDeptRepository signOutDeptRepository;

    public Y9Result<Object> addSignDept(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String deptIds, @RequestParam String deptType, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, positionId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.signDeptInfoService.addSignDept(processSerialNumber, deptType, deptIds);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteById(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, positionId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.signDeptInfoService.deleteById(id);
        return Y9Result.success();
    }

    public Y9Result<Map<String, String>> findByDeptNameMax(@RequestParam String tenantId, @RequestParam String deptNameMax) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HashMap<String, String> map = new HashMap<String, String>();
        SignOutDept signOutDept = this.signDeptOutService.findByDeptNameMax(deptNameMax);
        if (signOutDept != null) {
            String fullDeptName = signOutDept.getFullDeptName();
            String ldcw = signOutDept.getLdcw();
            String deptName = signOutDept.getDeptName();
            String deptSuffix = signOutDept.getDeptSuffix();
            map.put("fullDeptName", fullDeptName);
            map.put("ldcw", ldcw);
            map.put("deptName", deptName);
            map.put("deptSuffix", deptSuffix);
        }
        return Y9Result.success(map);
    }

    public Y9Result<List<SignDeptModel>> getSignDeptList(@RequestParam String tenantId, @RequestParam String deptType, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<SignDeptInfo> list = this.signDeptInfoService.getSignDeptList(processSerialNumber, deptType);
        ArrayList<SignDeptModel> modelList = new ArrayList<SignDeptModel>();
        for (SignDeptInfo signDeptInfo : list) {
            SignDeptModel model = new SignDeptModel();
            Y9BeanUtil.copyProperties((Object)signDeptInfo, (Object)model);
            modelList.add(model);
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<List<Department>> getSignOutDeptTree(@RequestParam String tenantId, @RequestParam(required=false) String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<Department> modelList = new ArrayList<Department>();
        if (StringUtils.isBlank((CharSequence)id)) {
            List typelist = this.signOutDeptTypeRepository.findByIsForbiddenOrderByTabIndexAsc(Integer.valueOf(0));
            for (SignOutDeptType info : typelist) {
                Department department = new Department();
                department.setId(String.valueOf(info.getDeptTypeId()));
                department.setOrgType(OrgTypeEnum.DEPARTMENT);
                department.setName(info.getDeptType());
                department.setParentId("");
                modelList.add(department);
            }
        } else {
            List list = this.signOutDeptRepository.findByDeptTypeIdAndIsForbiddenOrderByDeptOrderAsc(id, Integer.valueOf(0));
            for (SignOutDept signOutDept : list) {
                Department department = new Department();
                department.setId(signOutDept.getDeptId());
                department.setOrgType(OrgTypeEnum.DEPARTMENT);
                department.setName(signOutDept.getDeptName());
                department.setParentId(signOutDept.getDeptTypeId());
                modelList.add(department);
            }
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<Boolean> isSignDept(@RequestParam String tenantId, @RequestParam String deptId, @RequestParam String deptType, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<SignDeptInfo> list = this.signDeptInfoService.getSignDeptList(processSerialNumber, deptType);
        if (list.isEmpty()) {
            return Y9Result.success((Object)false);
        }
        return Y9Result.success((Object)list.stream().anyMatch(signDeptInfo -> signDeptInfo.getDeptId().equals(deptId)));
    }

    public Y9Result<Object> saveSignDept(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String deptIds, @RequestParam String deptType, @RequestParam String processSerialNumber, String tzsDeptId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, positionId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.signDeptInfoService.saveSignDept(processSerialNumber, deptType, deptIds, tzsDeptId);
        return Y9Result.success();
    }

    public Y9Result<Object> saveSignDeptInfo(@RequestParam String tenantId, @RequestParam String id, String userName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.signDeptInfoService.saveSignDeptInfo(id, userName);
        return Y9Result.success();
    }

    public Y9Result<Object> updateSignDept(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processSerialNumber, @RequestParam String type, @RequestParam String tzsDeptId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, positionId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.signDeptInfoService.updateSignDept(processSerialNumber, positionId, type, tzsDeptId);
        return Y9Result.success();
    }

    @Generated
    public SignDeptInfoApiImpl(SignDeptInfoService signDeptInfoService, OrgUnitApi orgUnitApi, SignDeptOutService signDeptOutService, SignOutDeptTypeRepository signOutDeptTypeRepository, SignOutDeptRepository signOutDeptRepository) {
        this.signDeptInfoService = signDeptInfoService;
        this.orgUnitApi = orgUnitApi;
        this.signDeptOutService = signDeptOutService;
        this.signOutDeptTypeRepository = signOutDeptTypeRepository;
        this.signOutDeptRepository = signOutDeptRepository;
    }
}

