/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.SignDeptDetailApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.OpinionSign;
import net.risesoft.entity.SignDeptDetail;
import net.risesoft.model.itemadmin.OpinionSignModel;
import net.risesoft.model.itemadmin.SignDeptDetailModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OpinionSignService;
import net.risesoft.service.SignDeptDetailService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/signDeptDetail"}, produces={"application/json"})
public class SignDeptDetailApiImpl
implements SignDeptDetailApi {
    private final SignDeptDetailService signDeptDetailService;
    private final OrgUnitApi orgUnitApi;
    private final OpinionSignService opinionSignService;

    public Y9Result<Object> deleteById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.signDeptDetailService.deleteById(id);
        return Y9Result.success();
    }

    public Y9Result<Object> recoverById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.signDeptDetailService.recoverById(id);
        return Y9Result.success();
    }

    public Y9Result<SignDeptDetailModel> findById(String tenantId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SignDeptDetail signDeptDetail = this.signDeptDetailService.findById(id);
        if (null != signDeptDetail) {
            SignDeptDetailModel model = new SignDeptDetailModel();
            Y9BeanUtil.copyProperties((Object)signDeptDetail, (Object)model);
            List<OpinionSign> opinionList = this.opinionSignService.findBySignDeptDetailId(model.getId());
            ArrayList osModelList = new ArrayList();
            opinionList.forEach(os -> {
                OpinionSignModel osModel = new OpinionSignModel();
                Y9BeanUtil.copyProperties((Object)os, (Object)osModel);
                osModelList.add(osModel);
            });
            model.setOpinionList(osModelList);
            return Y9Result.success((Object)model);
        }
        return Y9Result.failure((String)"\u672a\u627e\u5230\u4f1a\u7b7e\u90e8\u95e8\u8be6\u60c5");
    }

    public Y9Result<List<SignDeptDetailModel>> findByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<SignDeptDetail> list = this.signDeptDetailService.findByProcessSerialNumber(processSerialNumber);
        ArrayList<SignDeptDetailModel> modelList = new ArrayList<SignDeptDetailModel>();
        for (SignDeptDetail signDeptDetail : list) {
            SignDeptDetailModel model = new SignDeptDetailModel();
            Y9BeanUtil.copyProperties((Object)signDeptDetail, (Object)model);
            modelList.add(model);
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<SignDeptDetailModel> findByProcessSerialNumberAndDeptId4Latest(String tenantId, String processSerialNumber, String deptId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SignDeptDetail signDeptDetail = this.signDeptDetailService.findByProcessSerialNumberAndDeptId4Latest(processSerialNumber, deptId);
        if (null != signDeptDetail) {
            SignDeptDetailModel model = new SignDeptDetailModel();
            Y9BeanUtil.copyProperties((Object)signDeptDetail, (Object)model);
            return Y9Result.success((Object)model);
        }
        return Y9Result.failure((String)"\u672a\u627e\u5230\u4f1a\u7b7e\u90e8\u95e8\u8be6\u60c5");
    }

    public Y9Result<List<SignDeptDetailModel>> findByProcessSerialNumberAndStatus(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam int status) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<SignDeptDetail> list = this.signDeptDetailService.findByProcessSerialNumberAndStatus(processSerialNumber, status);
        ArrayList<SignDeptDetailModel> modelList = new ArrayList<SignDeptDetailModel>();
        for (SignDeptDetail signDeptDetail : list) {
            SignDeptDetailModel model = new SignDeptDetailModel();
            Y9BeanUtil.copyProperties((Object)signDeptDetail, (Object)model);
            List<OpinionSign> opinionList = this.opinionSignService.findBySignDeptDetailId(model.getId());
            ArrayList osModelList = new ArrayList();
            opinionList.forEach(os -> {
                OpinionSignModel osModel = new OpinionSignModel();
                Y9BeanUtil.copyProperties((Object)os, (Object)osModel);
                osModelList.add(osModel);
            });
            model.setOpinionList(osModelList);
            modelList.add(model);
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<Object> saveOrUpdate(@RequestParam String tenantId, @RequestParam String positionId, @RequestBody SignDeptDetailModel signDeptDetailModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, positionId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        SignDeptDetail signDeptDetail = new SignDeptDetail();
        Y9BeanUtil.copyProperties((Object)signDeptDetailModel, (Object)signDeptDetail);
        this.signDeptDetailService.saveOrUpdate(signDeptDetail);
        return Y9Result.success();
    }

    public Y9Result<Object> updateFileStoreId(String tenantId, String signId, String fileStoreId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.signDeptDetailService.updateFileStoreId(signId, fileStoreId);
        return Y9Result.success();
    }

    @Generated
    public SignDeptDetailApiImpl(SignDeptDetailService signDeptDetailService, OrgUnitApi orgUnitApi, OpinionSignService opinionSignService) {
        this.signDeptDetailService = signDeptDetailService;
        this.orgUnitApi = orgUnitApi;
        this.opinionSignService = opinionSignService;
    }
}

