/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.SecretLevelRecordApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.tenant.TenantApi;
import net.risesoft.entity.DmyjInfo;
import net.risesoft.entity.DmyjSxInfo;
import net.risesoft.entity.SecretLevelRecord;
import net.risesoft.model.itemadmin.DmyjInfoModel;
import net.risesoft.model.itemadmin.SecretLevelModel;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Tenant;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.DmyjInfoRepository;
import net.risesoft.repository.jpa.DmyjSxInfoRepository;
import net.risesoft.service.SecretLevelRecordService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/secretLevelRecord"}, produces={"application/json"})
public class SecretLevelRecordApiImpl
implements SecretLevelRecordApi {
    private final SecretLevelRecordService secretLevelRecordService;
    private final PersonApi personApi;
    private final TenantApi tenantApi;
    private final DmyjInfoRepository dmyjInfoRepository;
    private final DmyjSxInfoRepository dmyjSxInfoRepository;

    public Y9Result<List<DmyjInfoModel>> getDmyjInfo(@RequestParam String tenantId, @RequestParam String miji, String dmyjmc, @RequestParam String dmyjsj) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<DmyjInfoModel> list = new ArrayList<DmyjInfoModel>();
        if (StringUtils.isBlank((CharSequence)dmyjmc)) {
            System.out.println("dmyjmc\u4e3a\u7a7a");
            List dmyjInfoList = this.dmyjInfoRepository.getDmyjInfo(miji, "%" + dmyjsj + "%");
            for (DmyjInfo info : dmyjInfoList) {
                DmyjInfoModel model = new DmyjInfoModel();
                Y9BeanUtil.copyProperties((Object)info, (Object)model);
                list.add(model);
            }
        } else {
            List dmyjInfoList = this.dmyjSxInfoRepository.getDmyjSxInfo(miji, dmyjmc, "%" + dmyjsj + "%");
            for (DmyjSxInfo info : dmyjInfoList) {
                DmyjInfoModel model = new DmyjInfoModel();
                Y9BeanUtil.copyProperties((Object)info, (Object)model);
                list.add(model);
            }
        }
        return Y9Result.success(list);
    }

    public Y9Result<List<SecretLevelModel>> getRecord(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<SecretLevelModel> list = new ArrayList<SecretLevelModel>();
        List<SecretLevelRecord> secretLevelRecordList = this.secretLevelRecordService.getRecord(processSerialNumber);
        for (SecretLevelRecord secretLevelRecord : secretLevelRecordList) {
            SecretLevelModel secretLevelModel = new SecretLevelModel();
            Y9BeanUtil.copyProperties((Object)secretLevelRecord, (Object)secretLevelModel);
            list.add(secretLevelModel);
        }
        return Y9Result.success(list);
    }

    public Y9Result<Object> saveRecord(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, @RequestParam String secretLevel, @RequestParam String secretBasis, String secretItem, String description, @RequestParam String tableName, @RequestParam String fieldName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPersonId((String)userId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        Tenant tenant = (Tenant)this.tenantApi.getById(tenantId).getData();
        Y9LoginUserHolder.setTenantShortName((String)tenant.getShortName());
        this.secretLevelRecordService.save(processSerialNumber, secretLevel, secretBasis, secretItem, description, tableName, fieldName);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public SecretLevelRecordApiImpl(SecretLevelRecordService secretLevelRecordService, PersonApi personApi, TenantApi tenantApi, DmyjInfoRepository dmyjInfoRepository, DmyjSxInfoRepository dmyjSxInfoRepository) {
        this.secretLevelRecordService = secretLevelRecordService;
        this.personApi = personApi;
        this.tenantApi = tenantApi;
        this.dmyjInfoRepository = dmyjInfoRepository;
        this.dmyjSxInfoRepository = dmyjSxInfoRepository;
    }
}

