/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.PrintLogApi;
import net.risesoft.entity.PrintLog;
import net.risesoft.entity.ProcessParam;
import net.risesoft.model.itemadmin.PrintLogModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.PrintLogService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/printLog"}, produces={"application/json"})
public class PrintLogApiImpl
implements PrintLogApi {
    private final PrintLogService printLogService;
    private final ProcessParamService processParamService;

    public Y9Result<List<PrintLogModel>> getPrintLogList(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<PrintLog> printLogList = this.printLogService.getPrintLogList(processSerialNumber);
        ArrayList<PrintLogModel> list = new ArrayList<PrintLogModel>();
        for (PrintLog printLog : printLogList) {
            PrintLogModel printLogModel = new PrintLogModel();
            Y9BeanUtil.copyProperties((Object)printLog, (Object)printLogModel);
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            if (null != processParam) {
                printLogModel.setTitle(processParam.getTitle());
            }
            list.add(printLogModel);
        }
        return Y9Result.success(list);
    }

    public Y9Result<Object> savePrintLog(@RequestParam String tenantId, @RequestBody PrintLogModel printLog) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        PrintLog log = new PrintLog();
        Y9BeanUtil.copyProperties((Object)printLog, (Object)log);
        this.printLogService.savePrintLog(log);
        return Y9Result.success();
    }

    @Generated
    public PrintLogApiImpl(PrintLogService printLogService, ProcessParamService processParamService) {
        this.printLogService = printLogService;
        this.processParamService = processParamService;
    }
}

