/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.OpinionSignApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.OpinionSign;
import net.risesoft.model.itemadmin.OpinionSignListModel;
import net.risesoft.model.itemadmin.OpinionSignModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OpinionSignService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/opinionSign"}, produces={"application/json"})
public class OpinionSignApiImpl
implements OpinionSignApi {
    private final OpinionSignService opinionSignService;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitApi;

    public Y9Result<Boolean> checkSignOpinion(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)true);
    }

    public Y9Result<Object> delete(@RequestParam String tenantId, @RequestParam String id) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.opinionSignService.deleteById(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    public Y9Result<OpinionSignModel> getById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OpinionSign opinionSign = this.opinionSignService.findById(id);
        OpinionSignModel model = new OpinionSignModel();
        if (opinionSign != null) {
            Y9BeanUtil.copyProperties((Object)opinionSign, (Object)model);
            return Y9Result.success((Object)model);
        }
        return Y9Result.failure((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
    }

    public Y9Result<List<OpinionSignListModel>> personCommentList(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestParam String processSerialNumber, @RequestParam String signDeptDetailId, @RequestParam String itembox, @RequestParam(required=false) String taskId, @RequestParam String opinionFrameMark) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        Y9LoginUserHolder.setOrgUnitId((String)positionId);
        List<OpinionSignListModel> opinionList = this.opinionSignService.list(processSerialNumber, signDeptDetailId, itembox, taskId, opinionFrameMark);
        return Y9Result.success(opinionList);
    }

    public Y9Result<OpinionSignModel> saveOrUpdate(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, @RequestBody OpinionSignModel opinionSignModel) throws Exception {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        OpinionSign opinionSign = new OpinionSign();
        Y9BeanUtil.copyProperties((Object)opinionSignModel, (Object)opinionSign);
        opinionSign = this.opinionSignService.saveOrUpdate(opinionSign);
        Y9BeanUtil.copyProperties((Object)opinionSign, (Object)opinionSignModel);
        return Y9Result.success((Object)opinionSignModel);
    }

    @Generated
    public OpinionSignApiImpl(OpinionSignService opinionSignService, PersonApi personApi, OrgUnitApi orgUnitApi) {
        this.opinionSignService = opinionSignService;
        this.personApi = personApi;
        this.orgUnitApi = orgUnitApi;
    }
}

