/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.itemadmin.OpinionCopyApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.DocumentCopy;
import net.risesoft.entity.OpinionCopy;
import net.risesoft.enums.DocumentCopyStatusEnum;
import net.risesoft.model.itemadmin.OpinionCopyModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DocumentCopyService;
import net.risesoft.service.OpinionCopyService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/opinionCopy"}, produces={"application/json"})
public class OpinionCopyApiImpl
implements OpinionCopyApi {
    private final DocumentCopyService documentCopyService;
    private final OpinionCopyService opinionCopyService;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitApi;

    public Y9Result<List<OpinionCopyModel>> findByProcessSerialNumber(String tenantId, String userId, String orgUnitId, String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<OpinionCopy> ocList = this.opinionCopyService.findByProcessSerialNumber(processSerialNumber);
        ArrayList modelList = new ArrayList();
        ocList.forEach(opinionCopy -> {
            OpinionCopyModel model = new OpinionCopyModel();
            Y9BeanUtil.copyProperties((Object)opinionCopy, (Object)model);
            if (opinionCopy.isSend()) {
                List<DocumentCopy> dcList = this.documentCopyService.findByOpinionCopyId(opinionCopy.getId());
                StringBuffer userNames = new StringBuffer();
                dcList.stream().filter(dc -> dc.getStatus() < DocumentCopyStatusEnum.CANCEL.getValue()).collect(Collectors.toList()).forEach(dc -> {
                    if (userNames.toString().isEmpty()) {
                        userNames.append(dc.getUserName());
                    } else {
                        userNames.append("\uff0c").append(dc.getUserName());
                    }
                });
                model.setUserNames(userNames.toString());
            }
            modelList.add(model);
        });
        return Y9Result.success(modelList);
    }

    public Y9Result<OpinionCopyModel> saveOrUpdate(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, @RequestBody OpinionCopyModel opinionCopyModel) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        OpinionCopy opinionCopy = new OpinionCopy();
        Y9BeanUtil.copyProperties((Object)opinionCopyModel, (Object)opinionCopy);
        Optional<OpinionCopy> optional = this.opinionCopyService.saveOrUpdate(opinionCopy);
        if (optional.isPresent()) {
            List<DocumentCopy> dcList = this.documentCopyService.findByProcessSerialNumberAndUserIdAndStatus(opinionCopy.getProcessSerialNumber(), orgUnitId, DocumentCopyStatusEnum.TODO_SIGN.getValue());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dcList.forEach(dc -> {
                dc.setStatus(DocumentCopyStatusEnum.SIGN.getValue());
                dc.setUpdateTime(sdf.format(new Date()));
                this.documentCopyService.save((DocumentCopy)dc);
            });
            Y9BeanUtil.copyProperties((Object)optional.get(), (Object)opinionCopyModel);
            return Y9Result.success((Object)opinionCopyModel);
        }
        return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    public Y9Result<Object> deleteById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.opinionCopyService.deleteById(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @Generated
    public OpinionCopyApiImpl(DocumentCopyService documentCopyService, OpinionCopyService opinionCopyService, PersonApi personApi, OrgUnitApi orgUnitApi) {
        this.documentCopyService = documentCopyService;
        this.opinionCopyService = opinionCopyService;
        this.personApi = personApi;
        this.orgUnitApi = orgUnitApi;
    }
}

