/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.MergeFileApi;
import net.risesoft.entity.MergeFile;
import net.risesoft.model.itemadmin.MergeFileModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.MergeFileRepository;
import net.risesoft.service.MergeFileService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/mergeFile"}, produces={"application/json"})
public class MergeFileApiImpl
implements MergeFileApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeFileApiImpl.class);
    private final MergeFileRepository mergeFileRepository;
    private final MergeFileService mergeFileService;

    public Y9Result<Object> delMergeFile(@RequestParam String tenantId, @RequestParam String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.mergeFileService.delMergeFile(ids);
    }

    public Y9Result<List<MergeFileModel>> findByIds(@RequestParam String tenantId, @RequestParam String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.mergeFileRepository.findByIdIn(ids);
        ArrayList<MergeFileModel> res_list = new ArrayList<MergeFileModel>();
        for (MergeFile mergeFile : list) {
            MergeFileModel mergeFileModel = new MergeFileModel();
            Y9BeanUtil.copyProperties((Object)mergeFile, (Object)mergeFileModel);
            res_list.add(mergeFileModel);
        }
        return Y9Result.success(res_list);
    }

    public Y9Result<MergeFileModel> getMergeFile(String tenantId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        MergeFile mergeFile = this.mergeFileRepository.findById((Object)id).orElse(null);
        if (mergeFile != null) {
            MergeFileModel mergeFileModel = new MergeFileModel();
            Y9BeanUtil.copyProperties((Object)mergeFile, (Object)mergeFileModel);
            return Y9Result.success((Object)mergeFileModel);
        }
        return Y9Result.success(null);
    }

    public Y9Result<List<MergeFileModel>> getMergeFileList(@RequestParam String tenantId, @RequestParam String personId, String processSerialNumber, @RequestParam String listType, @RequestParam String fileType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<MergeFile> list = this.mergeFileService.getMergeFileList(personId, processSerialNumber, listType, fileType);
        ArrayList<MergeFileModel> res_list = new ArrayList<MergeFileModel>();
        for (MergeFile mergeFile : list) {
            MergeFileModel mergeFileModel = new MergeFileModel();
            Y9BeanUtil.copyProperties((Object)mergeFile, (Object)mergeFileModel);
            res_list.add(mergeFileModel);
        }
        return Y9Result.success(res_list);
    }

    public Y9Result<List<MergeFileModel>> getOfdFile(String tenantId, String sourceFileId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.mergeFileRepository.findBySourceFileId(sourceFileId);
        ArrayList<MergeFileModel> res_list = new ArrayList<MergeFileModel>();
        for (MergeFile mergeFile : list) {
            MergeFileModel mergeFileModel = new MergeFileModel();
            Y9BeanUtil.copyProperties((Object)mergeFile, (Object)mergeFileModel);
            res_list.add(mergeFileModel);
        }
        return Y9Result.success(res_list);
    }

    public Y9Result<Object> saveMergeFile(@RequestParam String tenantId, @RequestBody MergeFileModel mergeFileModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        MergeFile mergeFile = new MergeFile();
        Y9BeanUtil.copyProperties((Object)mergeFileModel, (Object)mergeFile);
        this.mergeFileService.saveMergeFile(mergeFile);
        return Y9Result.success((Object)mergeFile);
    }

    public Y9Result<Object> updateFileName(@RequestParam String tenantId, @RequestParam String id, @RequestParam String fileName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        MergeFile mergeFile = this.mergeFileRepository.findById((Object)id).orElse(null);
        if (mergeFile != null) {
            mergeFile.setFileName(fileName);
            this.mergeFileService.saveMergeFile(mergeFile);
        }
        return Y9Result.success();
    }

    @Generated
    public MergeFileApiImpl(MergeFileRepository mergeFileRepository, MergeFileService mergeFileService) {
        this.mergeFileRepository = mergeFileRepository;
        this.mergeFileService = mergeFileService;
    }
}

