/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemTodoApi;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.enums.ActRuDetailSignStatusEnum;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.model.itemadmin.ItemPage;
import net.risesoft.model.itemadmin.QueryParamModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ActRuDetailService;
import net.risesoft.service.ItemPageService;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemTodo"}, produces={"application/json"})
public class ItemTodoApiImpl
implements ItemTodoApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemTodoApiImpl.class);
    private final ItemPageService itemPageService;
    private final ActRuDetailService actRuDetailService;
    private final Y9TableService y9TableService;
    private final JdbcTemplate jdbcTemplate;

    public ItemTodoApiImpl(ItemPageService itemPageService, ActRuDetailService actRuDetailService, Y9TableService y9TableService, @Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate) {
        this.itemPageService = itemPageService;
        this.actRuDetailService = actRuDetailService;
        this.y9TableService = y9TableService;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Y9Result<Integer> countByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.actRuDetailService.countBySystemNameAndAssigneeAndStatus(systemName, userId, 0));
    }

    public Y9Page<ActRuDetailModel> findByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Page<ActRuDetail> ardPage = this.actRuDetailService.pageBySystemNameAndAssigneeAndStatus(systemName, userId, 0, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public Y9Page<ActRuDetailModel> findByUserIdAndSystemNameAndTaskDefKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam String taskDefKey, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Page<ActRuDetail> ardPage = StringUtils.isNotBlank((CharSequence)taskDefKey) ? this.actRuDetailService.pageBySystemNameAndAssigneeAndStatusAndTaskDefKey(systemName, userId, 0, taskDefKey, rows, page, sort) : this.actRuDetailService.pageBySystemNameAndAssigneeAndStatus(systemName, userId, 0, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public Y9Page<ActRuDetailModel> findByUserId(@RequestParam String tenantId, @RequestParam String userId, QueryParamModel queryParamModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        int page = queryParamModel.getPage();
        int rows = queryParamModel.getRows();
        boolean isEmpty = this.checkObjAllFieldsIsNull(queryParamModel);
        if (!isEmpty) {
            Field[] fields;
            Object systemNameSql = "";
            String processParamSql = "LEFT JOIN FF_PROCESS_PARAM P ON T.PROCESSSERIALNUMBER = P.PROCESSSERIALNUMBER ";
            StringBuilder sql1 = new StringBuilder();
            QueryParamModel object = queryParamModel;
            Class<?> queryParamModelClazz = object.getClass();
            for (Field field : fields = queryParamModelClazz.getDeclaredFields()) {
                field.setAccessible(true);
                if ("serialVersionUID".equals(field.getName()) || "page".equals(field.getName()) || "rows".equals(field.getName())) continue;
                try {
                    Object fieldValue = field.get(object);
                    if (null == fieldValue) continue;
                    if ("systemName".equals(field.getName())) {
                        systemNameSql = StringUtils.isBlank((CharSequence)queryParamModel.getSystemName()) ? "" : "AND T.SYSTEMNAME = '" + fieldValue + "' ";
                        continue;
                    }
                    if ("bureauIds".equals(field.getName())) {
                        sql1.append(" AND P.HOSTDEPTID = '").append(fieldValue).append("' ");
                        continue;
                    }
                    sql1.append("AND INSTR(P.").append(field.getName().toUpperCase()).append(",'").append(fieldValue).append("') > 0 ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String orderBy = "T.CREATETIME DESC";
            String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + processParamSql + " WHERE T.STATUS = 0 AND T.DELETED = FALSE " + sql1 + (String)systemNameSql + " AND T.ASSIGNEE = ? ORDER BY " + orderBy;
            String countSql = "SELECT COUNT(T.ID) FROM FF_ACT_RU_DETAIL T " + processParamSql + " WHERE T.ASSIGNEE= ? AND T.STATUS=0 AND T.DELETED = FALSE " + sql1 + (String)systemNameSql;
            Object[] args = new Object[]{userId};
            ItemPage ardModelPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, page, rows);
            return Y9Page.success((int)page, (int)ardModelPage.getTotalpages(), (long)ardModelPage.getTotal(), (List)ardModelPage.getRows());
        }
        Page<ActRuDetail> ardPage = this.actRuDetailService.pageByAssigneeAndStatus(userId, 0, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public boolean checkObjAllFieldsIsNull(Object object) {
        if (null == object) {
            return true;
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if ("serialVersionUID".equals(field.getName()) || "page".equals(field.getName()) || "rows".equals(field.getName()) || field.get(object) == null || !StringUtils.isNotBlank((CharSequence)field.get(object).toString())) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Y9Page<ActRuDetailModel> searchByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        List<String> sqlList = this.y9TableService.getSql(searchMap);
        String innerSql = sqlList.get(0);
        String whereSql = sqlList.get(1);
        StringBuilder assigneeNameSql = new StringBuilder();
        if (null != searchMap.get("assigneeName")) {
            assigneeNameSql.append("AND INSTR(T.ASSIGNEENAME").append(",'").append(searchMap.get("assigneeName").toString()).append("') > 0 ");
        }
        boolean sign = null != searchMap.get("sign");
        boolean noSign = null != searchMap.get("noSign");
        StringBuilder signSql = new StringBuilder();
        if (sign || noSign) {
            if (sign && noSign) {
                signSql.append(" AND ").append("T.SIGNSTATUS>=0");
            } else {
                signSql.append(" AND ").append("T.SIGNSTATUS=").append(sign ? ActRuDetailSignStatusEnum.DONE.getValue() : ActRuDetailSignStatusEnum.TODO.getValue());
            }
        }
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + " ORDER BY T.CREATETIME DESC";
        String countSql = "SELECT COUNT(*) FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql;
        Object[] args = new Object[]{systemName, userId};
        ItemPage ardPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)page, (int)ardPage.getTotalpages(), (long)ardPage.getTotal(), (List)ardPage.getRows());
    }

    public Y9Result<List<ActRuDetailModel>> searchListByUserIdAndSystemNameAndTaskDefKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam(required=false) String taskDefKey, @RequestBody(required=false) String searchMapStr) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String innerSql = "";
        String whereSql = "";
        StringBuilder assigneeNameSql = new StringBuilder();
        StringBuilder signSql = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)searchMapStr)) {
            boolean noSign;
            HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
            assert (searchMap != null);
            List<String> sqlList = this.y9TableService.getSql(searchMap);
            innerSql = sqlList.get(0);
            whereSql = sqlList.get(1);
            if (null != searchMap.get("assigneeName")) {
                assigneeNameSql.append("AND INSTR(T.ASSIGNEENAME").append(",'").append(searchMap.get("assigneeName").toString()).append("') > 0 ");
            }
            boolean sign = null != searchMap.get("sign");
            boolean bl = noSign = null != searchMap.get("noSign");
            if (sign || noSign) {
                if (sign && noSign) {
                    signSql.append(" AND ").append("T.SIGNSTATUS>=0");
                } else {
                    signSql.append(" AND ").append("T.SIGNSTATUS=").append(sign ? ActRuDetailSignStatusEnum.DONE.getValue() : ActRuDetailSignStatusEnum.TODO.getValue());
                }
            }
        }
        StringBuilder taskDefKeySql = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)taskDefKey)) {
            taskDefKeySql.append(" AND T.taskDefKey='").append(taskDefKey).append("'");
        }
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + taskDefKeySql + " ORDER BY T.CREATETIME DESC";
        Object[] args = new Object[]{systemName, userId};
        List content = this.jdbcTemplate.query(sql, args, (RowMapper)new BeanPropertyRowMapper(ActRuDetailModel.class));
        return Y9Result.success((Object)content);
    }

    public Y9Page<ActRuDetailModel> searchByUserIdAndSystemName4Other(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody(required=false) String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String innerSql = "";
        String whereSql = "";
        StringBuilder assigneeNameSql = new StringBuilder();
        StringBuilder signSql = new StringBuilder();
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        String commonSql = searchMap.get("commonSql").toString();
        String numberSql = searchMap.get("numberSql").toString();
        if (StringUtils.isNotBlank((CharSequence)searchMapStr)) {
            boolean noSign;
            List<String> sqlList = this.y9TableService.getSql(searchMap);
            innerSql = sqlList.get(0);
            whereSql = sqlList.get(1);
            if (null != searchMap.get("assigneeName")) {
                assigneeNameSql.append("AND INSTR(T.ASSIGNEENAME").append(",'").append(searchMap.get("assigneeName").toString()).append("') > 0 ");
            }
            boolean sign = null != searchMap.get("sign");
            boolean bl = noSign = null != searchMap.get("noSign");
            if (sign || noSign) {
                if (sign && noSign) {
                    signSql.append(" AND ").append("T.SIGNSTATUS>=0");
                } else {
                    signSql.append(" AND ").append("T.SIGNSTATUS=").append(sign ? ActRuDetailSignStatusEnum.DONE.getValue() : ActRuDetailSignStatusEnum.TODO.getValue());
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)innerSql)) {
            innerSql = "INNER JOIN Y9_FORM_FW FW ON T.PROCESSSERIALNUMBER = FW.GUID";
        }
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + commonSql + " AND T.PROCESSSERIALNUMBER NOT IN (" + numberSql + ")  ORDER BY T.CREATETIME DESC";
        String countSql = "SELECT COUNT(*) FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + commonSql + " AND T.PROCESSSERIALNUMBER NOT IN (" + numberSql + ")";
        Object[] args = new Object[]{systemName, userId};
        ItemPage ardPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)page, (int)ardPage.getTotalpages(), (long)ardPage.getTotal(), (List)ardPage.getRows());
    }

    public Y9Result<List<ActRuDetailModel>> searchListByUserIdAndSystemName4Other(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody(required=false) String searchMapStr) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String innerSql = "";
        String whereSql = "";
        StringBuilder assigneeNameSql = new StringBuilder();
        StringBuilder signSql = new StringBuilder();
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        String commonSql = searchMap.get("commonSql").toString();
        String numberSql = searchMap.get("numberSql").toString();
        if (StringUtils.isNotBlank((CharSequence)searchMapStr)) {
            boolean noSign;
            List<String> sqlList = this.y9TableService.getSql(searchMap);
            innerSql = sqlList.get(0);
            whereSql = sqlList.get(1);
            if (null != searchMap.get("assigneeName")) {
                assigneeNameSql.append("AND INSTR(T.ASSIGNEENAME").append(",'").append(searchMap.get("assigneeName").toString()).append("') > 0 ");
            }
            boolean sign = null != searchMap.get("sign");
            boolean bl = noSign = null != searchMap.get("noSign");
            if (sign || noSign) {
                if (sign && noSign) {
                    signSql.append(" AND ").append("T.SIGNSTATUS>=0");
                } else {
                    signSql.append(" AND ").append("T.SIGNSTATUS=").append(sign ? ActRuDetailSignStatusEnum.DONE.getValue() : ActRuDetailSignStatusEnum.TODO.getValue());
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)innerSql)) {
            innerSql = "INNER JOIN Y9_FORM_FW FW ON T.PROCESSSERIALNUMBER = FW.GUID";
        }
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + commonSql + " AND T.PROCESSSERIALNUMBER NOT IN (" + numberSql + ")  ORDER BY T.CREATETIME DESC";
        Object[] args = new Object[]{systemName, userId};
        List content = this.jdbcTemplate.query(sql, args, (RowMapper)new BeanPropertyRowMapper(ActRuDetailModel.class));
        return Y9Result.success((Object)content);
    }

    public Y9Page<ActRuDetailModel> searchByUserIdAndSystemNameAndTaskDefKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam(required=false) String taskDefKey, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        List<String> sqlList = this.y9TableService.getSql(searchMap);
        String innerSql = sqlList.get(0);
        String whereSql = sqlList.get(1);
        StringBuilder assigneeNameSql = new StringBuilder();
        if (null != searchMap.get("assigneeName")) {
            assigneeNameSql.append("AND INSTR(T.ASSIGNEENAME").append(",'").append(searchMap.get("assigneeName").toString()).append("') > 0 ");
        }
        boolean sign = null != searchMap.get("sign");
        boolean noSign = null != searchMap.get("noSign");
        StringBuilder signSql = new StringBuilder();
        if (sign || noSign) {
            if (sign && noSign) {
                signSql.append(" AND ").append("T.SIGNSTATUS>=0");
            } else {
                signSql.append(" AND ").append("T.SIGNSTATUS=").append(sign ? ActRuDetailSignStatusEnum.DONE.getValue() : ActRuDetailSignStatusEnum.TODO.getValue());
            }
        }
        StringBuilder taskDefKeySql = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)taskDefKey)) {
            taskDefKeySql.append(" AND T.taskDefKey='").append(taskDefKey).append("'");
        }
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + taskDefKeySql + " ORDER BY T.CREATETIME DESC";
        String countSql = "SELECT COUNT(*) FROM FF_ACT_RU_DETAIL T " + innerSql + " WHERE T.DELETED = FALSE AND T.STATUS = 0 AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ?" + whereSql + assigneeNameSql + signSql + taskDefKeySql;
        Object[] args = new Object[]{systemName, userId};
        ItemPage ardPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)page, (int)ardPage.getTotalpages(), (long)ardPage.getTotal(), (List)ardPage.getRows());
    }
}

