/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.risesoft.api.itemadmin.ItemAllApi;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.model.itemadmin.ItemPage;
import net.risesoft.model.itemadmin.QueryParamModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ActRuDetailService;
import net.risesoft.service.ItemPageService;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemAll"}, produces={"application/json"})
public class ItemAllApiImpl
implements ItemAllApi {
    private final ItemPageService itemPageService;
    private final ActRuDetailService actRuDetailService;
    private final Y9TableService y9TableService;
    private final JdbcTemplate jdbcTemplate;

    public ItemAllApiImpl(ItemPageService itemPageService, ActRuDetailService actRuDetailService, Y9TableService y9TableService, @Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate) {
        this.itemPageService = itemPageService;
        this.actRuDetailService = actRuDetailService;
        this.y9TableService = y9TableService;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Y9Result<Integer> countByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.actRuDetailService.countBySystemNameAndAssigneeAndStatus(systemName, userId, 0));
    }

    public Y9Page<ActRuDetailModel> findByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Page<ActRuDetail> ardPage = this.actRuDetailService.pageBySystemNameAndAssignee(systemName, userId, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public Y9Page<ActRuDetailModel> findBySystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Page<ActRuDetail> ardPage = this.actRuDetailService.pageBySystemName(systemName, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public Y9Page<ActRuDetailModel> findByUserId(@RequestParam String tenantId, @RequestParam String userId, QueryParamModel queryParamModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        int page = queryParamModel.getPage();
        int rows = queryParamModel.getRows();
        boolean isEmpty = this.checkObjAllFieldsIsNull(queryParamModel);
        if (!isEmpty) {
            Field[] fields;
            Object systemNameSql = "";
            String processParamSql = "LEFT JOIN FF_PROCESS_PARAM F ON T.PROCESSSERIALNUMBER = F.PROCESSSERIALNUMBER ";
            StringBuilder sql1 = new StringBuilder();
            QueryParamModel object = queryParamModel;
            Class<?> queryParamModelClazz = object.getClass();
            for (Field f : fields = queryParamModelClazz.getDeclaredFields()) {
                f.setAccessible(true);
                if ("serialVersionUID".equals(f.getName()) || "page".equals(f.getName()) || "rows".equals(f.getName())) continue;
                try {
                    Object fieldValue = f.get(object);
                    if (null == fieldValue) continue;
                    if ("systemName".equals(f.getName())) {
                        systemNameSql = StringUtils.isBlank((CharSequence)queryParamModel.getSystemName()) ? "" : "AND T.SYSTEMNAME = '" + fieldValue + "' ";
                        continue;
                    }
                    sql1.append("AND INSTR(F.").append(f.getName().toUpperCase()).append(",'").append(fieldValue).append("') > 0 ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String orderBy = "T.CREATETIME DESC";
            String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + processParamSql + " WHERE T.STATUS = 0 AND T.DELETED = FALSE " + sql1 + (String)systemNameSql + " AND T.ASSIGNEE = ? ORDER BY " + orderBy;
            String countSql = "SELECT COUNT(T.ID) FROM FF_ACT_RU_DETAIL T " + processParamSql + " WHERE T.ASSIGNEE= ? AND T.STATUS=0 AND T.DELETED = FALSE " + sql1 + (String)systemNameSql;
            Object[] args = new Object[]{userId};
            ItemPage ardModelPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, page, rows);
            return Y9Page.success((int)page, (int)ardModelPage.getTotalpages(), (long)ardModelPage.getTotal(), (List)ardModelPage.getRows());
        }
        Page<ActRuDetail> ardPage = this.actRuDetailService.pageByAssigneeAndStatus(userId, 0, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public boolean checkObjAllFieldsIsNull(Object object) {
        if (null == object) {
            return true;
        }
        try {
            for (Field f : object.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if ("serialVersionUID".equals(f.getName()) || "page".equals(f.getName()) || "rows".equals(f.getName()) || f.get(object) == null || !StringUtils.isNotBlank((CharSequence)f.get(object).toString())) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Y9Page<ActRuDetailModel> searchByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        List<String> sqlList = this.y9TableService.getSql(searchMap);
        String innerSql = sqlList.get(0);
        String whereSql = sqlList.get(1);
        String assigneeNameInnerSql = sqlList.get(2);
        String assigneeNameWhereSql = sqlList.get(3);
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + assigneeNameInnerSql + " WHERE T.DELETED = FALSE AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ? " + whereSql + assigneeNameWhereSql + " ORDER BY T.CREATETIME DESC";
        String countSql = "SELECT COUNT(*) FROM FF_ACT_RU_DETAIL T " + innerSql + assigneeNameInnerSql + " WHERE T.DELETED = FALSE AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ? " + whereSql + assigneeNameWhereSql;
        Object[] args = new Object[]{systemName, userId};
        ItemPage ardPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)page, (int)ardPage.getTotalpages(), (long)ardPage.getTotal(), (List)ardPage.getRows());
    }

    public Y9Page<ActRuDetailModel> searchBySystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        List<String> sqlList = this.y9TableService.getSql(searchMap);
        String innerSql = sqlList.get(0);
        String whereSql = sqlList.get(1);
        String assigneeNameInnerSql = sqlList.get(2);
        String assigneeNameWhereSql = sqlList.get(3);
        String sql = "SELECT A.* FROM (SELECT T.*,ROW_NUMBER() OVER (PARTITION BY T.PROCESSSERIALNUMBER ORDER BY T.LASTTIME DESC) AS RS_NUM FROM FF_ACT_RU_DETAIL T " + innerSql + assigneeNameInnerSql + " WHERE T.DELETED = FALSE AND T.SYSTEMNAME = ? " + whereSql + assigneeNameWhereSql + " ORDER BY T.CREATETIME DESC) A WHERE A.RS_NUM = 1";
        String countSql = "SELECT COUNT(*) FROM (SELECT A.* FROM (SELECT ROW_NUMBER () OVER ( PARTITION BY T.PROCESSSERIALNUMBER ORDER BY T.LASTTIME DESC ) AS RS_NUM FROM FF_ACT_RU_DETAIL T " + innerSql + assigneeNameInnerSql + " WHERE T.DELETED = FALSE AND T.SYSTEMNAME = ?" + whereSql + assigneeNameWhereSql + " ) A WHERE A.RS_NUM = 1) ALIAS";
        Object[] args = new Object[]{systemName};
        ItemPage itemPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)itemPage.getCurrpage(), (int)itemPage.getTotalpages(), (long)itemPage.getTotal(), (List)itemPage.getRows());
    }

    public Y9Result<List<ActRuDetailModel>> searchListBySystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody String searchMapStr) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        List<String> sqlList = this.y9TableService.getSql(searchMap);
        String innerSql = sqlList.get(0);
        String whereSql = sqlList.get(1);
        String assigneeNameInnerSql = sqlList.get(2);
        String assigneeNameWhereSql = sqlList.get(3);
        String sql = "SELECT A.* FROM (SELECT T.*,ROW_NUMBER() OVER (PARTITION BY T.PROCESSSERIALNUMBER ORDER BY T.LASTTIME DESC) AS RS_NUM   FROM FF_ACT_RU_DETAIL T " + innerSql + assigneeNameInnerSql + " WHERE T.DELETED = FALSE AND T.SYSTEMNAME = ? " + whereSql + assigneeNameWhereSql + " ORDER BY T.CREATETIME DESC) A WHERE A.RS_NUM = 1";
        Object[] args = new Object[]{systemName};
        List content = this.jdbcTemplate.query(sql, args, (RowMapper)new BeanPropertyRowMapper(ActRuDetailModel.class));
        return Y9Result.success((Object)content);
    }

    public Y9Result<List<ActRuDetailModel>> searchListByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestBody(required=false) String searchMapStr) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String innerSql = "";
        String whereSql = "";
        String assigneeNameInnerSql = "";
        String assigneeNameWhereSql = "";
        if (StringUtils.isNotBlank((CharSequence)searchMapStr)) {
            HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
            assert (searchMap != null);
            List<String> sqlList = this.y9TableService.getSql(searchMap);
            innerSql = sqlList.get(0);
            whereSql = sqlList.get(1);
            assigneeNameInnerSql = sqlList.get(2);
            assigneeNameWhereSql = sqlList.get(3);
        }
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + innerSql + assigneeNameInnerSql + " WHERE T.DELETED = FALSE AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ? " + whereSql + assigneeNameWhereSql + " ORDER BY T.CREATETIME DESC";
        Object[] args = new Object[]{systemName, userId};
        List content = this.jdbcTemplate.query(sql, args, (RowMapper)new BeanPropertyRowMapper(ActRuDetailModel.class));
        return Y9Result.success((Object)content);
    }

    public Y9Result<List<ActRuDetailModel>> searchByProcessSerialNumbers(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String[] processSerialNumbers) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        StringBuilder sb = new StringBuilder();
        Arrays.stream(processSerialNumbers).forEach(processSerialNumber -> {
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                sb.append("'").append((String)processSerialNumber).append("'");
            } else {
                sb.append(",'").append((String)processSerialNumber).append("'");
            }
        });
        String sql = "SELECT A.* FROM (SELECT T.*,ROW_NUMBER() OVER (PARTITION BY T.PROCESSSERIALNUMBER ORDER BY T.LASTTIME DESC) AS RS_NUM FROM FF_ACT_RU_DETAIL T WHERE T.PROCESSSERIALNUMBER IN (" + sb + ") ORDER BY T.CREATETIME DESC) A WHERE A.RS_NUM = 1";
        List content = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(ActRuDetailModel.class));
        return Y9Result.success((Object)content);
    }
}

