/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.DocumentWordApi;
import net.risesoft.entity.DocumentHistoryWord;
import net.risesoft.entity.DocumentWord;
import net.risesoft.model.itemadmin.DocumentWordModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.DocumentHistoryWordRepository;
import net.risesoft.service.DocumentHisWordService;
import net.risesoft.service.DocumentWordService;
import net.risesoft.service.config.ItemWordConfService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/docWord"}, produces={"application/json"})
public class DocumentWordApiImpl
implements DocumentWordApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentWordApiImpl.class);
    private final DocumentHistoryWordRepository documentHistoryWordRepository;
    private final DocumentWordService documentWordService;
    private final ItemWordConfService itemWordConfService;
    private final DocumentHisWordService documentHisWordService;

    public Y9Result<Object> copyByProcessSerialNumberAndWordType(@RequestParam String tenantId, @RequestParam String sourceProcessSerialNumber, @RequestParam String targetProcessSerialNumber, @RequestParam String wordType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.documentWordService.copyByProcessSerialNumberAndWordType(sourceProcessSerialNumber, targetProcessSerialNumber, wordType);
    }

    public Y9Result<List<DocumentWordModel>> findByProcessSerialNumberAndWordType(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String wordType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<DocumentWordModel> list = this.documentWordService.findByProcessSerialNumberAndWordType(processSerialNumber, wordType);
        return Y9Result.success(list);
    }

    public Y9Result<List<DocumentWordModel>> findHisByProcessSerialNumberAndWordType(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String wordType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.documentHistoryWordRepository.findByProcessSerialNumberAndWordTypeOrderByUpdateDateAsc(processSerialNumber, wordType);
        ArrayList<DocumentWordModel> resultList = new ArrayList<DocumentWordModel>();
        for (DocumentHistoryWord documentWord : list) {
            DocumentWordModel documentWordModel = new DocumentWordModel();
            Y9BeanUtil.copyProperties((Object)documentWord, (Object)documentWordModel);
            resultList.add(documentWordModel);
        }
        return Y9Result.success(resultList);
    }

    public Y9Result<DocumentWordModel> findHisWordById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        DocumentHistoryWord documentWord = this.documentHisWordService.findWordById(id);
        DocumentWordModel documentWordModel = null;
        if (documentWord != null) {
            documentWordModel = new DocumentWordModel();
            Y9BeanUtil.copyProperties((Object)documentWord, (Object)documentWordModel);
        }
        return Y9Result.success(documentWordModel);
    }

    public Y9Result<DocumentWordModel> findWordById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        DocumentWord documentWord = this.documentWordService.findWordById(id);
        DocumentWordModel documentWordModel = null;
        if (documentWord != null) {
            documentWordModel = new DocumentWordModel();
            Y9BeanUtil.copyProperties((Object)documentWord, (Object)documentWordModel);
        }
        return Y9Result.success(documentWordModel);
    }

    public Y9Result<Boolean> getPermissionWord(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey, @RequestParam String wordType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.itemWordConfService.getPermissionWord(positionId, itemId, processDefinitionId, taskDefKey, wordType));
    }

    public Y9Result<Object> replaceWord(@RequestParam String tenantId, @RequestBody DocumentWordModel documentWordModel, @RequestParam String oldId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        DocumentWord documentWord = new DocumentWord();
        Y9BeanUtil.copyProperties((Object)documentWordModel, (Object)documentWord);
        this.documentWordService.replaceWord(documentWord, oldId, taskId);
        return Y9Result.success();
    }

    public Y9Result<DocumentWordModel> saveWord(@RequestParam String tenantId, @RequestBody DocumentWordModel documentWordModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        DocumentWord documentWord = new DocumentWord();
        Y9BeanUtil.copyProperties((Object)documentWordModel, (Object)documentWord);
        DocumentWord newWord = this.documentWordService.saveWord(documentWord);
        DocumentWordModel documentWordModelResult = new DocumentWordModel();
        Y9BeanUtil.copyProperties((Object)newWord, (Object)documentWordModelResult);
        return Y9Result.success((Object)documentWordModelResult);
    }

    @Generated
    public DocumentWordApiImpl(DocumentHistoryWordRepository documentHistoryWordRepository, DocumentWordService documentWordService, ItemWordConfService itemWordConfService, DocumentHisWordService documentHisWordService) {
        this.documentHistoryWordRepository = documentHistoryWordRepository;
        this.documentWordService = documentWordService;
        this.itemWordConfService = itemWordConfService;
        this.documentHisWordService = documentHisWordService;
    }
}

