/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.risesoft.api.itemadmin.DocumentCopyApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.DocumentCopy;
import net.risesoft.entity.OpinionCopy;
import net.risesoft.entity.ProcessParam;
import net.risesoft.enums.DocumentCopyStatusEnum;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.DocumentCopyModel;
import net.risesoft.model.itemadmin.ItemPage;
import net.risesoft.model.itemadmin.QueryParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DocumentCopyService;
import net.risesoft.service.ItemPageService;
import net.risesoft.service.OpinionCopyService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/documentCopy"}, produces={"application/json"})
public class DocumentCopyApiImpl
implements DocumentCopyApi {
    private final DocumentCopyService documentCopyService;
    private final ProcessParamService processParamService;
    private final OpinionCopyService opinionCopyService;
    private final ItemPageService itemPageService;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitApi;
    private final JdbcTemplate jdbcTemplate;

    public DocumentCopyApiImpl(DocumentCopyService documentCopyService, ProcessParamService processParamService, OpinionCopyService opinionCopyService, ItemPageService itemPageService, PersonApi personApi, OrgUnitApi orgUnitApi, @Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate) {
        this.documentCopyService = documentCopyService;
        this.processParamService = processParamService;
        this.opinionCopyService = opinionCopyService;
        this.itemPageService = itemPageService;
        this.personApi = personApi;
        this.orgUnitApi = orgUnitApi;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Y9Page<DocumentCopyModel> findByUserId(String tenantId, String userId, String orgUnitId, QueryParamModel queryParamModel) {
        Field[] fields;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int page = queryParamModel.getPage();
        int rows = queryParamModel.getRows();
        Object systemNameSql = "";
        StringBuilder paramSql = new StringBuilder();
        QueryParamModel object = queryParamModel;
        Class<?> queryParamModelClazz = object.getClass();
        for (Field f : fields = queryParamModelClazz.getDeclaredFields()) {
            f.setAccessible(true);
            if ("serialVersionUID".equals(f.getName()) || "page".equals(f.getName()) || "rows".equals(f.getName())) continue;
            try {
                Object fieldValue = f.get(object);
                if (null == fieldValue) continue;
                if ("systemName".equals(f.getName())) {
                    systemNameSql = StringUtils.isBlank((CharSequence)queryParamModel.getSystemName()) ? "" : " AND P.SYSTEMNAME = '" + fieldValue + "' ";
                    continue;
                }
                if ("bureauIds".equals(f.getName())) {
                    paramSql.append(" AND P.HOSTDEPTID = '").append(fieldValue).append("' ");
                    continue;
                }
                paramSql.append(" AND INSTR(P.").append(f.getName().toUpperCase()).append(",'").append(fieldValue).append("') > 0 ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String leftJoinSql = "LEFT JOIN FF_PROCESS_PARAM P ON C.PROCESSSERIALNUMBER = P.PROCESSSERIALNUMBER ";
        String bySql = "ORDER BY P.CREATETIME DESC ) A WHERE A.RS_NUM = 1";
        String allSql = "SELECT A.* FROM (SELECT C.*,P.SYSTEMCNNAME,P.TITLE,P.HOSTDEPTNAME,P.CUSTOMNUMBER,ROW_NUMBER() OVER (PARTITION BY C.PROCESSSERIALNUMBER ORDER BY P.CREATETIME DESC) AS RS_NUM FROM FF_DOCUMENT_COPY C " + leftJoinSql + " WHERE C.STATUS < " + DocumentCopyStatusEnum.CANCEL.getValue() + " AND USERID = ? " + paramSql + (String)systemNameSql + bySql;
        String countSql = "SELECT COUNT(*) FROM ( SELECT ROW_NUMBER() OVER (PARTITION BY C.PROCESSSERIALNUMBER ORDER BY P.CREATETIME DESC) AS RS_NUM  FROM FF_DOCUMENT_COPY C " + leftJoinSql + " WHERE C.STATUS < " + DocumentCopyStatusEnum.CANCEL.getValue() + " AND USERID = ? " + paramSql + (String)systemNameSql + ") ALIAS WHERE RS_NUM =1";
        Object[] args = new Object[]{orgUnitId};
        ItemPage ardModelPage = this.itemPageService.page(allSql, args, new BeanPropertyRowMapper(DocumentCopyModel.class), countSql, args, page, rows);
        return Y9Page.success((int)page, (int)ardModelPage.getTotalpages(), (long)ardModelPage.getTotal(), (List)ardModelPage.getRows());
    }

    public Y9Result<List<DocumentCopyModel>> findByProcessSerialNumbers(String tenantId, String userId, String orgUnitId, String[] processSerialNumbers) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        StringBuilder sb = new StringBuilder();
        Arrays.stream(processSerialNumbers).forEach(processSerialNumber -> {
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                sb.append("'").append((String)processSerialNumber).append("'");
            } else {
                sb.append(",'").append((String)processSerialNumber).append("'");
            }
        });
        String sql = "SELECT A.* FROM (SELECT C.*,P.SYSTEMCNNAME,P.TITLE,P.HOSTDEPTNAME,P.CUSTOMNUMBER,ROW_NUMBER() OVER (PARTITION BY C.PROCESSSERIALNUMBER ORDER BY P.CREATETIME DESC) AS RS_NUM FROM FF_DOCUMENT_COPY C LEFT JOIN FF_PROCESS_PARAM P ON C.PROCESSSERIALNUMBER = P.PROCESSSERIALNUMBER WHERE C.PROCESSSERIALNUMBER IN ( " + sb + ") ORDER BY P.CREATETIME DESC ) A WHERE A.RS_NUM = 1";
        List content = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(DocumentCopyModel.class));
        return Y9Result.success((Object)content);
    }

    public Y9Result<List<DocumentCopyModel>> findListByUserId(String tenantId, String userId, String orgUnitId, @RequestBody(required=false) QueryParamModel queryParamModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Object systemNameSql = "";
        StringBuilder paramSql = new StringBuilder();
        if (null != queryParamModel) {
            Field[] fields;
            QueryParamModel object = queryParamModel;
            Class<?> queryParamModelClazz = object.getClass();
            for (Field f : fields = queryParamModelClazz.getDeclaredFields()) {
                f.setAccessible(true);
                if ("serialVersionUID".equals(f.getName()) || "page".equals(f.getName()) || "rows".equals(f.getName())) continue;
                try {
                    Object fieldValue = f.get(object);
                    if (null == fieldValue) continue;
                    if ("systemName".equals(f.getName())) {
                        systemNameSql = StringUtils.isBlank((CharSequence)queryParamModel.getSystemName()) ? "" : " AND P.SYSTEMNAME = '" + fieldValue + "' ";
                        continue;
                    }
                    paramSql.append(" AND INSTR(P.").append(f.getName().toUpperCase()).append(",'").append(fieldValue).append("') > 0 ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String processParamSql = "LEFT JOIN FF_PROCESS_PARAM P ON C.PROCESSSERIALNUMBER = P.PROCESSSERIALNUMBER ";
        String bySql = " ORDER BY P.CREATETIME DESC) A WHERE A.RS_NUM = 1";
        String allSql = "SELECT A.* FROM (SELECT C.*,P.SYSTEMCNNAME,P.TITLE,P.HOSTDEPTNAME,P.CUSTOMNUMBER,ROW_NUMBER() OVER (PARTITION BY C.PROCESSSERIALNUMBER ORDER BY P.CREATETIME DESC) AS RS_NUM FROM FF_DOCUMENT_COPY C " + processParamSql + " WHERE C.STATUS < " + DocumentCopyStatusEnum.CANCEL.getValue() + paramSql + (String)systemNameSql + " AND C.USERID = ? " + bySql;
        Object[] args = new Object[]{orgUnitId};
        List content = this.jdbcTemplate.query(allSql, args, (RowMapper)new BeanPropertyRowMapper(DocumentCopyModel.class));
        return Y9Result.success((Object)content);
    }

    public Y9Result<List<DocumentCopyModel>> findByProcessSerialNumberAndSenderId(String tenantId, String userId, String orgUnitId, String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<DocumentCopy> dcList = this.documentCopyService.findByProcessSerialNumberAndSenderId(processSerialNumber, orgUnitId);
        ArrayList modelList = new ArrayList();
        dcList.forEach(documentCopy -> {
            DocumentCopyModel model = new DocumentCopyModel();
            Y9BeanUtil.copyProperties((Object)documentCopy, (Object)model);
            modelList.add(model);
        });
        return Y9Result.success(modelList);
    }

    public Y9Result<Object> save(String tenantId, String userId, String orgUnitId, String processSerialNumber, String users, String opinion) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, orgUnitId).getData();
        OpinionCopy newOc = new OpinionCopy();
        newOc.setId(Y9IdGenerator.genId());
        newOc.setProcessSerialNumber(processSerialNumber);
        newOc.setContent(StringUtils.isBlank((CharSequence)opinion) ? "\u65e0" : opinion);
        newOc.setSend(true);
        Optional<OpinionCopy> optional = this.opinionCopyService.saveOrUpdate(newOc);
        if (optional.isPresent()) {
            String opinionCopyId = optional.get().getId();
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ArrayList<DocumentCopy> list = new ArrayList<DocumentCopy>();
            Arrays.stream(users.split(";")).forEach(user -> {
                String[] nameAndId = user.split(":");
                DocumentCopy documentCopy = new DocumentCopy();
                documentCopy.setId(Y9IdGenerator.genId());
                documentCopy.setOpinionCopyId(opinionCopyId);
                documentCopy.setProcessSerialNumber(processSerialNumber);
                documentCopy.setProcessInstanceId(processParam.getProcessInstanceId());
                documentCopy.setUserName(nameAndId[0]);
                documentCopy.setUserId(nameAndId[1]);
                documentCopy.setSenderId(orgUnitId);
                documentCopy.setSenderName(orgUnit.getName());
                documentCopy.setStatus(DocumentCopyStatusEnum.TODO_SIGN.getValue());
                documentCopy.setSystemName(processParam.getSystemName());
                documentCopy.setCreateTime(sdf.format(new Date()));
                documentCopy.setUpdateTime(sdf.format(new Date()));
                list.add(documentCopy);
            });
            this.documentCopyService.save(list);
            return Y9Result.success();
        }
        return Y9Result.failure((String)"\u4fdd\u5b58\u610f\u89c1\u5931\u8d25");
    }

    public Y9Result<Object> setStatus(String tenantId, String userId, String orgUnitId, String id, Integer status) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Optional<DocumentCopy> optional = this.documentCopyService.findById(id);
        if (optional.isPresent()) {
            DocumentCopy documentCopy = optional.get();
            documentCopy.setStatus(status);
            documentCopy.setUpdateTime(sdf.format(new Date()));
            this.documentCopyService.save(documentCopy);
            return Y9Result.success();
        }
        return Y9Result.failure((String)"\u4f20\u7b7e\u4ef6\u4e0d\u5b58\u5728");
    }

    public Y9Result<Object> deleteByProcessSerialNumber(String tenantId, String userId, String orgUnitId, String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<DocumentCopy> dcList = this.documentCopyService.findByProcessSerialNumberAndUserId(processSerialNumber, orgUnitId);
        dcList.stream().filter(documentCopy -> documentCopy.getStatus() < DocumentCopyStatusEnum.CANCEL.getValue()).forEach(documentCopy -> {
            documentCopy.setStatus(DocumentCopyStatusEnum.DELETE.getValue());
            documentCopy.setUpdateTime(sdf.format(new Date()));
            this.documentCopyService.save((DocumentCopy)documentCopy);
        });
        return Y9Result.success();
    }
}

