/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import lombok.Generated;
import net.risesoft.api.itemadmin.ChaoSong4DataBaseApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.ChaoSong;
import net.risesoft.model.itemadmin.ChaoSongModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ChaoSongService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/chaoSong4database"}, produces={"application/json"})
public class ChaoSong4DataBaseApiImpl
implements ChaoSong4DataBaseApi {
    private final ChaoSongService chaoSongService;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitApi;

    public Y9Result<Object> changeChaoSongState(@RequestParam String tenantId, @RequestParam String id, String type) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongService.changeChaoSongState(id, type);
        return Y9Result.success();
    }

    public Y9Result<Object> changeStatus(@RequestParam String tenantId, @RequestBody String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongService.changeStatus(ids);
        return Y9Result.success();
    }

    public Y9Result<Object> changeStatus2read(@RequestParam String tenantId, @RequestParam String chaoSongId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongService.changeStatus(chaoSongId);
        return Y9Result.success();
    }

    public Y9Result<Integer> countByProcessInstanceId(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongService.countByProcessInstanceId(orgUnitId, processInstanceId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Integer> countByUserIdAndProcessInstanceId(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongService.countByUserIdAndProcessInstanceId(orgUnitId, processInstanceId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Object> deleteByIds(@RequestParam String tenantId, @RequestBody String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongService.deleteByIds(ids);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongService.deleteByProcessInstanceId(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<OpenDataModel> detail(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String id, @RequestParam String processInstanceId, @RequestParam Integer status, Boolean openNotRead, @RequestParam boolean mobile) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setOrgUnitId((String)orgUnitId);
        OpenDataModel model = this.chaoSongService.detail(processInstanceId, status, mobile);
        model.setId(id);
        model.setStatus(status);
        ChaoSong chaoSong = this.chaoSongService.getById(id);
        if (null != chaoSong && chaoSong.getStatus() != 1 && !Boolean.TRUE.equals(openNotRead)) {
            this.chaoSongService.changeStatus(id);
        }
        return Y9Result.success((Object)model);
    }

    public Y9Result<Integer> getDone4OpinionCountByUserId(@RequestParam String tenantId, @RequestParam String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongService.getDone4OpinionCountByUserId(orgUnitId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Integer> getDoneCount(@RequestParam String tenantId, @RequestParam String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongService.getDoneCountByUserId(orgUnitId);
        return Y9Result.success((Object)num);
    }

    public Y9Page<ChaoSongModel> getDoneList(@RequestParam String tenantId, @RequestParam String orgUnitId, String documentTitle, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongService.pageDoneList(orgUnitId, documentTitle, rows, page);
    }

    public Y9Page<ChaoSongModel> getListByProcessInstanceId(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String processInstanceId, String userName, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setOrgUnitId((String)orgUnitId);
        return this.chaoSongService.pageByProcessInstanceIdAndUserName(processInstanceId, userName, rows, page);
    }

    public Y9Page<ChaoSongModel> getListBySenderIdAndProcessInstanceId(@RequestParam String tenantId, @RequestParam String senderId, @RequestParam String processInstanceId, String userName, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongService.pageBySenderIdAndProcessInstanceId(senderId, processInstanceId, userName, rows, page);
    }

    public Y9Page<ChaoSongModel> getOpinionChaosongByUserId(@RequestParam String tenantId, @RequestParam String orgUnitId, String documentTitle, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongService.pageOpinionChaosongByUserId(orgUnitId, documentTitle, rows, page);
    }

    public Y9Result<Integer> getTodoCount(@RequestParam String tenantId, @RequestParam String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongService.getTodoCountByUserId(orgUnitId);
        return Y9Result.success((Object)num);
    }

    public Y9Page<ChaoSongModel> getTodoList(@RequestParam String tenantId, @RequestParam String orgUnitId, String documentTitle, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongService.pageTodoList(orgUnitId, documentTitle, rows, page);
    }

    public Y9Page<ChaoSongModel> myChaoSongList(@RequestParam String tenantId, @RequestParam String orgUnitId, String searchName, String itemId, String userName, String state, String year, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setOrgUnitId((String)orgUnitId);
        return this.chaoSongService.pageMyChaoSongList(searchName, itemId, userName, state, year, rows, page);
    }

    public Y9Result<Object> save(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, @RequestParam String processInstanceId, @RequestParam String users, String isSendSms, String isShuMing, String smsContent, String smsPersonId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        return this.chaoSongService.save(processInstanceId, users, isSendSms, isShuMing, smsContent, smsPersonId);
    }

    public Y9Page<ChaoSongModel> searchAllByUserId(@RequestParam String tenantId, @RequestParam String orgUnitId, String searchName, String itemId, String userName, String state, String year, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setOrgUnitId((String)orgUnitId);
        return this.chaoSongService.searchAllByUserId(searchName, itemId, userName, state, year, page, rows);
    }

    public Y9Page<ChaoSongModel> searchAllList(@RequestParam String tenantId, String searchName, String itemId, String senderName, String userName, String state, String year, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongService.searchAllList(searchName, itemId, senderName, userName, state, year, page, rows);
    }

    public Y9Result<Object> updateTitle(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String documentTitle) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongService.updateTitle(processInstanceId, documentTitle);
        return Y9Result.success();
    }

    @Generated
    public ChaoSong4DataBaseApiImpl(ChaoSongService chaoSongService, PersonApi personApi, OrgUnitApi orgUnitApi) {
        this.chaoSongService = chaoSongService;
        this.personApi = personApi;
        this.orgUnitApi = orgUnitApi;
    }
}

