/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.AttachmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.AttachmentConf;
import net.risesoft.entity.TransactionFile;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.AttachmentConfModel;
import net.risesoft.model.itemadmin.AttachmentModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.AttachmentConfRepository;
import net.risesoft.repository.jpa.TransactionFileRepository;
import net.risesoft.service.TransactionFileService;
import net.risesoft.util.ItemAdminModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/attachment"}, produces={"application/json"})
public class AttachmentApiImpl
implements AttachmentApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentApiImpl.class);
    private final TransactionFileService transactionFileService;
    private final TransactionFileRepository transactionFileRepository;
    private final AttachmentConfRepository attachmentConfRepository;
    private final OrgUnitApi orgUnitApi;
    private final PersonApi personApi;

    public Y9Result<Object> delBatchByProcessSerialNumbers(@RequestParam String tenantId, @RequestBody List<String> processSerialNumbers) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.transactionFileService.delBatchByProcessSerialNumbers(processSerialNumbers);
        return Y9Result.success();
    }

    public Y9Result<Object> delFile(@RequestParam String tenantId, @RequestParam String ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.transactionFileService.delFile(ids);
        return Y9Result.success();
    }

    public Y9Result<Integer> fileCounts(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.transactionFileService.fileCounts(processSerialNumber);
        return Y9Result.success((Object)num);
    }

    public Y9Result<AttachmentModel> findById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        TransactionFile file = this.transactionFileService.findById(id);
        AttachmentModel model = null;
        if (file != null) {
            model = new AttachmentModel();
            Y9BeanUtil.copyProperties((Object)file, (Object)model);
        }
        return Y9Result.success(model);
    }

    public Y9Result<Integer> getAttachmentCount(@RequestParam String tenantId, @RequestParam String processSerialNumber, String fileSource, String fileType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        fileType = fileType.toLowerCase();
        int num = this.transactionFileService.getTransactionFileCount(processSerialNumber, fileSource, fileType);
        return Y9Result.success((Object)num);
    }

    public Y9Page<AttachmentModel> getAttachmentList(@RequestParam String tenantId, @RequestParam String processSerialNumber, String fileSource, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.transactionFileService.pageByProcessSerialNumber(processSerialNumber, fileSource, page, rows);
    }

    public Y9Result<List<AttachmentModel>> getAttachmentModelList(@RequestParam String tenantId, @RequestParam String processSerialNumber, String fileSource) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<TransactionFile> transactionFileList = this.transactionFileService.listSearchByProcessSerialNumber(processSerialNumber, fileSource);
        List<AttachmentModel> list = ItemAdminModelConvertUtil.attachmentList2ModelList(transactionFileList);
        return Y9Result.success(list);
    }

    public Y9Result<AttachmentModel> getFile(@RequestParam String tenantId, @RequestParam String fileId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        TransactionFile file = this.transactionFileRepository.findById((Object)fileId).orElse(null);
        AttachmentModel model = null;
        if (file != null) {
            model = new AttachmentModel();
            Y9BeanUtil.copyProperties((Object)file, (Object)model);
        }
        return Y9Result.success(model);
    }

    public Y9Result<Object> saveAttachment(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String attachjson, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map attachmentJson = (Map)Y9JsonUtil.readValue((String)attachjson, Map.class);
        assert (attachmentJson != null);
        List attachmentList = (List)attachmentJson.get("attachment");
        for (Map map : attachmentList) {
            TransactionFile file = new TransactionFile();
            file.setDescribes(map.get("describes") == null ? "" : map.get("describes").toString());
            file.setFileStoreId(map.get("filePath").toString());
            file.setFileSize(map.get("fileSize") == null ? "" : map.get("fileSize").toString());
            file.setFileSource(map.get("fileSource") == null ? "" : map.get("fileSource").toString());
            file.setFileType(map.get("fileType") == null ? "" : map.get("fileType").toString());
            file.setId(map.get("id").toString());
            file.setName(map.get("fileName").toString());
            file.setPersonId(map.get("personId") == null ? "" : map.get("personId").toString());
            file.setPersonName(map.get("personName") == null ? "" : map.get("personName").toString());
            file.setProcessSerialNumber(processSerialNumber);
            file.setUploadTime(sdf.format(new Date()));
            this.transactionFileService.save(file);
        }
        return Y9Result.success();
    }

    public Y9Result<String> saveOrUpdateUploadInfo(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String fileName, String fileType, String fileSizeString, String fileSource, String processInstanceId, String processSerialNumber, String taskId, @RequestParam String y9FileStoreId) {
        String msg;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            TransactionFile attachment = this.transactionFileService.getFileInfoByFileName(fileName, processSerialNumber);
            if (null != attachment) {
                attachment.setFileStoreId(y9FileStoreId);
                attachment.setName(fileName);
                attachment.setFileSize(fileSizeString);
                attachment.setTaskId(taskId);
                attachment.setPersonId(orgUnitId);
                attachment.setPersonName(orgUnit.getName());
                attachment.setUploadTime(sdf.format(new Date()));
                this.transactionFileRepository.save((Object)attachment);
            } else {
                TransactionFile fileAttachment = new TransactionFile();
                fileAttachment.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                fileAttachment.setFileStoreId(y9FileStoreId);
                fileAttachment.setName(fileName);
                fileAttachment.setFileSize(fileSizeString);
                fileAttachment.setFileType(fileType);
                fileAttachment.setUploadTime(sdf.format(new Date()));
                fileAttachment.setPersonId(orgUnitId);
                fileAttachment.setPersonName(orgUnit.getName());
                fileAttachment.setProcessInstanceId(processInstanceId);
                fileAttachment.setProcessSerialNumber(processSerialNumber);
                fileAttachment.setTaskId(taskId);
                fileAttachment.setFileSource(fileSource);
                fileAttachment.setTabIndex(Integer.valueOf(this.transactionFileService.fileCounts(processSerialNumber) + 1));
                this.transactionFileRepository.save((Object)fileAttachment);
            }
            msg = "success:true";
        }
        catch (Exception e) {
            LOGGER.error("saveOrUpdateUploadInfo error", (Throwable)e);
            msg = "success:false";
        }
        return Y9Result.success((Object)msg);
    }

    public Y9Result<String> updateFile(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String fileId, String fileSize, String taskId, @RequestParam String y9FileStoreId) {
        String msg;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            TransactionFile attachment = this.transactionFileRepository.findById((Object)fileId).orElse(null);
            if (null != attachment) {
                attachment.setFileStoreId(y9FileStoreId);
                attachment.setFileSize(fileSize);
                attachment.setUploadTime(sdf.format(new Date()));
                this.transactionFileRepository.save((Object)attachment);
            }
            msg = "success:true";
        }
        catch (Exception e) {
            LOGGER.error("updateFile error", (Throwable)e);
            msg = "success:false";
        }
        return Y9Result.success((Object)msg);
    }

    public Y9Result<String> upload(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, @RequestParam String fileName, String fileSize, String processInstanceId, String taskId, String describes, String processSerialNumber, String fileSource, @RequestParam String y9FileStoreId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        this.transactionFileService.uploadRest(fileName, fileSize, processInstanceId, taskId, processSerialNumber, describes, fileSource, y9FileStoreId);
        return Y9Result.successMsg((String)"\u4e0a\u4f20\u6210\u529f");
    }

    public Y9Result<Object> uploadModel(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestBody AttachmentModel attachmentModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        TransactionFile file = new TransactionFile();
        Y9BeanUtil.copyProperties((Object)attachmentModel, (Object)file);
        this.transactionFileService.uploadRestModel(file);
        return Y9Result.success();
    }

    public Y9Result<List<AttachmentConfModel>> findByAttachmentType(@RequestParam String tenantId, @RequestParam String attachmentType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<AttachmentConfModel> attachmentConfModelList = new ArrayList<AttachmentConfModel>();
        List attachmentConfList = this.attachmentConfRepository.findByAttachmentTypeOrderByTabIndexAsc(attachmentType);
        for (AttachmentConf attachmentConf : attachmentConfList) {
            AttachmentConfModel attachmentConfModel = new AttachmentConfModel();
            Y9BeanUtil.copyProperties((Object)attachmentConf, (Object)attachmentConfModel);
            attachmentConfModelList.add(attachmentConfModel);
        }
        return Y9Result.success(attachmentConfModelList);
    }

    @Generated
    public AttachmentApiImpl(TransactionFileService transactionFileService, TransactionFileRepository transactionFileRepository, AttachmentConfRepository attachmentConfRepository, OrgUnitApi orgUnitApi, PersonApi personApi) {
        this.transactionFileService = transactionFileService;
        this.transactionFileRepository = transactionFileRepository;
        this.attachmentConfRepository = attachmentConfRepository;
        this.orgUnitApi = orgUnitApi;
        this.personApi = personApi;
    }
}

