/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util.form;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.risesoft.repository.form.Y9TableFieldRepository;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.pojo.DbColumn;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DdlMysql {
    @Autowired
    private Y9TableFieldRepository y9TableFieldRepository = (Y9TableFieldRepository)Y9Context.getBean(Y9TableFieldRepository.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableColumn(DataSource dataSource, String tableName, List<DbColumn> dbcs) throws Exception {
        if (Y9FormDbMetaDataUtil.checkTableExist((DataSource)dataSource, (String)tableName)) {
            for (DbColumn dbc : dbcs) {
                String columnName = dbc.getColumnName();
                if ("guid".equalsIgnoreCase(columnName) || "processInstanceId".equalsIgnoreCase(columnName)) continue;
                String ddl = "ALTER TABLE " + tableName;
                String nullable = "";
                String dbColumnName = "";
                try (ResultSet rs = null;
                     Connection connection = dataSource.getConnection();){
                    DatabaseMetaData dbmd = connection.getMetaData();
                    String tableSchema = dbmd.getUserName().toUpperCase();
                    rs = dbmd.getColumns(null, tableSchema, tableName, dbc.getColumnName());
                    while (rs.next()) {
                        nullable = rs.getString("is_nullable");
                        dbColumnName = rs.getString("column_name".toLowerCase());
                    }
                }
                boolean add = false;
                if ("".equals(dbColumnName) && StringUtils.isBlank((CharSequence)dbc.getColumnNameOld())) {
                    ddl = ddl + " ADD COLUMN " + dbc.getColumnName() + " ";
                    add = true;
                } else {
                    ddl = dbc.getColumnName().equalsIgnoreCase(dbc.getColumnNameOld()) || StringUtils.isBlank((CharSequence)dbc.getColumnNameOld()) ? ddl + " MODIFY COLUMN " + dbc.getColumnName() + " " : ddl + " CHANGE COLUMN " + dbc.getColumnNameOld() + " " + dbc.getColumnName() + " ";
                }
                String sType = dbc.getTypeName().toUpperCase();
                ddl = "CHAR".equals(sType) || "VARCHAR".equals(sType) ? ddl + sType + "(" + dbc.getDataLength() + ")" : ("DECIMAL".equals(sType) || "NUMERIC".equals(sType) ? (dbc.getDataScale() == null ? ddl + sType + "(" + dbc.getDataLength() + ")" : ddl + sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")") : ddl + sType);
                ddl = "".equals(nullable) && add ? (dbc.getNullable().booleanValue() ? ddl + " DEFAULT NULL" : ddl + " NOT NULL") : (dbc.getNullable() != false ? ddl + " DEFAULT NULL" : ddl + " NOT NULL");
                if (dbc.getComment().length() > 0) {
                    ddl = ddl + " COMMENT '" + dbc.getComment() + "'";
                }
                Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)ddl);
                this.y9TableFieldRepository.updateOldFieldName(dbc.getTableName(), dbc.getColumnName());
            }
        }
    }

    public void alterTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        DbColumn[] dbcs;
        if (!Y9FormDbMetaDataUtil.checkTableExist((DataSource)dataSource, (String)tableName)) {
            throw new Exception("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8fd9\u4e2a\u8868\uff1a" + tableName);
        }
        for (DbColumn dbc : dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class))) {
            String ddl = "ALTER TABLE " + tableName;
            ddl = dbc.getColumnName().equalsIgnoreCase(dbc.getColumnNameOld()) ? ddl + " MODIFY COLUMN " + dbc.getColumnName() + " " : ddl + " CHANGE COLUMN " + dbc.getColumnNameOld() + " " + dbc.getColumnName() + " ";
            String sType = dbc.getTypeName().toUpperCase();
            ddl = "CHAR".equals(sType) || "VARCHAR".equals(sType) ? ddl + sType + "(" + dbc.getDataLength() + ")" : ("DECIMAL".equals(sType) || "NUMERIC".equals(sType) ? (dbc.getDataScale() == null ? ddl + sType + "(" + dbc.getDataLength() + ")" : ddl + sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")") : ddl + sType);
            ddl = dbc.getNullable() != false ? ddl + " DEFAULT NULL" : ddl + " NOT NULL";
            if (dbc.getComment().length() > 0) {
                ddl = ddl + " COMMENT '" + dbc.getComment() + "'";
            }
            Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)ddl);
        }
    }

    public void createTable(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        List dbcs = (List)Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)Y9JsonUtil.objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, DbColumn.class));
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + tableName + " (\r\n").append("guid varchar(38) NOT NULL, \r\n");
        for (DbColumn dbc : dbcs) {
            String columnName = dbc.getColumnName();
            if ("guid".equalsIgnoreCase(columnName) || "processInstanceId".equalsIgnoreCase(columnName)) continue;
            sb.append(columnName).append(" ");
            String sType = dbc.getTypeName().toUpperCase();
            if ("CHAR".equals(sType) || "VARCHAR".equals(sType)) {
                sb.append(sType + "(" + dbc.getDataLength() + ")");
            } else if ("DECIMAL".equals(sType) || "NUMERIC".equals(sType)) {
                if (dbc.getDataScale() == null) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else {
                    sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                }
            } else {
                sb.append(sType);
            }
            if (!dbc.getNullable().booleanValue()) {
                sb.append(" NOT NULL");
            }
            if (dbc.getComment().length() > 0) {
                sb.append(" COMMENT '" + dbc.getComment() + "'");
            }
            sb.append(",\r\n");
        }
        sb.append("PRIMARY KEY (guid) \r\n").append(")");
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)sb.toString());
    }

    public void dropTable(DataSource dataSource, String tableName) throws Exception {
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("drop table IF EXISTS " + tableName));
    }

    public void dropTableColumn(DataSource dataSource, String tableName, String columnName) throws Exception {
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("ALTER TABLE " + tableName + " DROP COLUMN " + columnName));
    }

    public void renameTable(DataSource dataSource, String tableNameOld, String tableNameNew) throws Exception {
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("ALTER TABLE " + tableNameOld + " RENAME " + tableNameNew));
    }
}

