/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class PropertiesUtil
implements InitializingBean {
    private Map systemProperties;

    public void afterPropertiesSet() throws Exception {
        if (this.systemProperties == null || this.systemProperties.isEmpty()) {
            return;
        }
        for (String key : this.systemProperties.keySet()) {
            String value = (String)this.systemProperties.get(key);
            System.setProperty(key, value);
        }
    }

    public Map<String, String> getAllProperties(String resourceUrl, List<String> list) {
        Properties prop = this.getProperties(resourceUrl);
        HashMap<String, String> result = new HashMap<String, String>(16);
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.put(key, prop.getProperty(key));
        }
        return result;
    }

    public List<String> getKeys(String resourceUrl) {
        Properties prop = this.getProperties(resourceUrl);
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            list.add(key);
        }
        return list;
    }

    public Properties getProperties(String resourceUrl) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource(resourceUrl);
        Properties prop = new Properties();
        try {
            InputStream in = resource.getInputStream();
            prop.load(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prop;
    }

    public String getProperty(String resourceUrl, String source) {
        Properties prop = this.getProperties(resourceUrl);
        return prop.getProperty(source);
    }

    public void save(String resourceUrl, Properties prop) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource(resourceUrl);
        try {
            File file = resource.getFile();
            FileOutputStream fos = new FileOutputStream(file);
            prop.store(fos, "");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void savePropertiy(String resourceUrl, String key, String value) {
        Properties prop = this.getProperties(resourceUrl);
        prop.setProperty(key, value);
        this.save(resourceUrl, prop);
    }

    public void setSystemProperties(Map systemProperties) {
        this.systemProperties = systemProperties;
    }
}

