/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.entity.DynamicRole;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.service.DynamicRoleMemberService;
import net.risesoft.service.DynamicRoleService;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.util.BeanFactory;
import net.risesoft.y9.Y9Context;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DynamicRoleMemberServiceImpl
implements DynamicRoleMemberService {
    private final DynamicRoleService dynamicRoleService;

    @Override
    public Department getDepartment(DynamicRole dynamicRole) {
        Department department = new Department();
        String classFullPath = dynamicRole.getClassPath();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)Y9Context.getAc();
        DefaultListableBeanFactory beanFactory = BeanFactory.getBeanFactory(applicationContext);
        beanFactory = BeanFactory.addBean(beanFactory, classFullPath);
        AbstractDynamicRoleMember dynamicRoleMemberService = (AbstractDynamicRoleMember)beanFactory.getBean(classFullPath);
        department = dynamicRoleMemberService.getDepartment();
        return department;
    }

    @Override
    public List<OrgUnit> listByDynamicRoleId(String dynamicRoleId) {
        DynamicRole dynamicRole = this.dynamicRoleService.getById(dynamicRoleId);
        ArrayList<OrgUnit> orgUnitList = new ArrayList();
        String classFullPath = dynamicRole.getClassPath();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)Y9Context.getAc();
        DefaultListableBeanFactory beanFactory = BeanFactory.getBeanFactory(applicationContext);
        beanFactory = BeanFactory.addBean(beanFactory, classFullPath);
        AbstractDynamicRoleMember dynamicRoleMemberService = (AbstractDynamicRoleMember)beanFactory.getBean(classFullPath);
        orgUnitList = dynamicRoleMemberService.getOrgUnitList();
        return orgUnitList;
    }

    @Override
    public List<OrgUnit> listByDynamicRoleIdAndProcessInstanceId(String dynamicRoleId, String processInstanceId) {
        DynamicRole dynamicRole = this.dynamicRoleService.getById(dynamicRoleId);
        List<Object> orgUnitList = new ArrayList();
        String classFullPath = dynamicRole.getClassPath();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)Y9Context.getAc();
        DefaultListableBeanFactory beanFactory = BeanFactory.getBeanFactory(applicationContext);
        beanFactory = BeanFactory.addBean(beanFactory, classFullPath);
        AbstractDynamicRoleMember dynamicRoleMemberService = (AbstractDynamicRoleMember)beanFactory.getBean(classFullPath);
        orgUnitList = dynamicRole.isUseProcessInstanceId() ? dynamicRoleMemberService.getOrgUnitList(processInstanceId) : dynamicRoleMemberService.getOrgUnitList();
        return orgUnitList;
    }

    @Generated
    public DynamicRoleMemberServiceImpl(DynamicRoleService dynamicRoleService) {
        this.dynamicRoleService = dynamicRoleService;
    }
}

