/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.enums.platform.DepartmentPropCategoryEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class StarterDeptLeaders
extends AbstractDynamicRoleMember {
    private final OrgUnitApi orgUnitApi;
    private final DepartmentApi departmentApi;
    private final RuntimeApi runtimeApi;

    @Override
    public List<OrgUnit> getOrgUnitList(String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            ProcessInstanceModel processInstance = (ProcessInstanceModel)this.runtimeApi.getProcessInstance(tenantId, processInstanceId).getData();
            String userIdAndDeptId = processInstance.getStartUserId();
            if (StringUtils.isNotEmpty((CharSequence)userIdAndDeptId)) {
                String userId = userIdAndDeptId.split(":")[0];
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
                List leaders = (List)this.departmentApi.listDepartmentPropOrgUnits(tenantId, orgUnit.getParentId(), DepartmentPropCategoryEnum.LEADER.getValue()).getData();
                orgUnitList.addAll(leaders);
            }
        } else {
            String userId = Y9LoginUserHolder.getOrgUnitId();
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
            List leaders = (List)this.departmentApi.listDepartmentPropOrgUnits(tenantId, orgUnit.getParentId(), DepartmentPropCategoryEnum.LEADER.getValue()).getData();
            orgUnitList.addAll(leaders);
        }
        return orgUnitList;
    }

    @Generated
    public StarterDeptLeaders(OrgUnitApi orgUnitApi, DepartmentApi departmentApi, RuntimeApi runtimeApi) {
        this.orgUnitApi = orgUnitApi;
        this.departmentApi = departmentApi;
        this.runtimeApi = runtimeApi;
    }
}

