/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.api.datacenter.OfficeInfoApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.HistoricProcessApi;
import net.risesoft.api.processadmin.HistoricVariableApi;
import net.risesoft.entity.AssociatedFile;
import net.risesoft.entity.ProcessParam;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.TransactionFile;
import net.risesoft.entity.TransactionWord;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.form.Y9FormField;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.datacenter.AttachmentInfo;
import net.risesoft.model.datacenter.EformInfo;
import net.risesoft.model.datacenter.HistoryInfo;
import net.risesoft.model.datacenter.OfficeInfo;
import net.risesoft.model.itemadmin.HistoryProcessModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.model.processadmin.HistoricVariableInstanceModel;
import net.risesoft.repository.form.Y9FormFieldRepository;
import net.risesoft.repository.form.Y9FormRepository;
import net.risesoft.repository.jpa.AssociatedFileRepository;
import net.risesoft.service.ProcessParamService;
import net.risesoft.service.ProcessTrackService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.TransactionFileService;
import net.risesoft.service.TransactionWordService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DataCenterService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCenterService.class);
    private final JdbcTemplate jdbcTemplate4Tenant;
    private final SpmApproveItemService spmApproveitemService;
    private final TransactionWordService transactionWordService;
    private final TransactionFileService transactionFileService;
    private final ProcessTrackService processTrackService;
    private final Y9FormItemBindService y9FormItemBindService;
    private final AssociatedFileRepository associatedFileRepository;
    private final ProcessParamService processParamService;
    private final Y9FormRepository y9FormRepository;
    private final OrgUnitApi orgUnitApi;
    private final Y9FormFieldRepository y9FormFieldRepository;
    private final OfficeInfoApi officeInfoApi;
    private final HistoricProcessApi historicProcessApi;
    private final HistoricVariableApi historicVariableApi;

    public DataCenterService(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate4Tenant, SpmApproveItemService spmApproveitemService, TransactionWordService transactionWordService, TransactionFileService transactionFileService, ProcessTrackService processTrackService, Y9FormItemBindService y9FormItemBindService, AssociatedFileRepository associatedFileRepository, ProcessParamService processParamService, Y9FormRepository y9FormRepository, OrgUnitApi orgUnitApi, Y9FormFieldRepository y9FormFieldRepository, OfficeInfoApi officeInfoApi, HistoricProcessApi historicProcessApi, HistoricVariableApi historicVariableApi) {
        this.jdbcTemplate4Tenant = jdbcTemplate4Tenant;
        this.spmApproveitemService = spmApproveitemService;
        this.transactionWordService = transactionWordService;
        this.transactionFileService = transactionFileService;
        this.processTrackService = processTrackService;
        this.y9FormItemBindService = y9FormItemBindService;
        this.associatedFileRepository = associatedFileRepository;
        this.processParamService = processParamService;
        this.y9FormRepository = y9FormRepository;
        this.orgUnitApi = orgUnitApi;
        this.y9FormFieldRepository = y9FormFieldRepository;
        this.officeInfoApi = officeInfoApi;
        this.historicProcessApi = historicProcessApi;
        this.historicVariableApi = historicVariableApi;
    }

    public List<EformInfo> getEformInfo(String processInstanceId, String processDefinitionKey, String processDefinitionId) {
        ArrayList<EformInfo> elist = new ArrayList<EformInfo>();
        try {
            LOGGER.info("************************************itemAdmin\u4fdd\u5b58\u8868\u5355\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3***********************************************");
            ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
            String itemId = processParam.getItemId();
            String processSerialNumber = processParam.getProcessSerialNumber();
            List<Y9FormItemBind> formBindData = this.y9FormItemBindService.listByItemIdAndProcDefId(itemId, processDefinitionId);
            for (Y9FormItemBind y9Form : formBindData) {
                EformInfo eformInfo = new EformInfo();
                String fieldNames = "";
                String fieldValues = "";
                DataSource dataSource = Objects.requireNonNull(this.jdbcTemplate4Tenant.getDataSource());
                String dialect = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
                List list = this.y9FormRepository.findBindTableName(y9Form.getFormId());
                for (String tableName : list) {
                    List datamap;
                    StringBuilder sqlStr = new StringBuilder();
                    if ("oracle".equals(dialect)) {
                        sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
                    } else if ("dm".equals(dialect)) {
                        sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
                    } else if ("kingbase".equals(dialect)) {
                        sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
                    } else if ("mysql".equals(dialect)) {
                        sqlStr = new StringBuilder("SELECT * FROM " + tableName + " where guid =?");
                    }
                    if ((datamap = this.jdbcTemplate4Tenant.queryForList(sqlStr.toString(), new Object[]{processSerialNumber})) == null || datamap.isEmpty()) continue;
                    List elementList = this.y9FormFieldRepository.findByFormIdAndTableName(y9Form.getFormId(), tableName);
                    for (Y9FormField element : elementList) {
                        String fieldName = element.getFieldName();
                        String fieldCnName = element.getFieldCnName();
                        if (element.getFieldName().equals("processInstanceId") || element.getFieldName().equals("guid")) continue;
                        fieldNames = Y9Util.genCustomStr((String)fieldNames, (String)fieldCnName, (String)"&");
                        fieldValues = Y9Util.genCustomStr((String)fieldValues, (String)(((Map)datamap.get(0)).get(fieldName) != null ? ((Map)datamap.get(0)).get(fieldName).toString() : ""), (String)"&");
                    }
                }
                eformInfo.setEformName(y9Form.getFormName());
                eformInfo.setFieldNames(fieldNames);
                eformInfo.setFieldValues(fieldValues);
                elist.add(eformInfo);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u4fdd\u5b58\u8868\u5355\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return elist;
    }

    public Map<String, Object> historyExcel(String processSerialNumber, String processInstanceId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        String undertaker = "";
        String userIds = "";
        retMap.put("undertaker", undertaker);
        retMap.put("userId", userIds);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            List<HistoryProcessModel> listMap = this.processTrackService.listByProcessInstanceId(processInstanceId);
            ArrayList<HistoryInfo> list = new ArrayList<HistoryInfo>();
            for (int i = 0; i < listMap.size(); ++i) {
                String userId;
                String assignee;
                HistoryProcessModel map = listMap.get(i);
                String string = assignee = StringUtils.isNotBlank((CharSequence)map.getAssignee()) ? map.getAssignee() : "";
                if (!undertaker.contains(assignee)) {
                    undertaker = Y9Util.genCustomStr((String)undertaker, (String)assignee);
                }
                String string2 = userId = StringUtils.isNotBlank((CharSequence)map.getUndertakerId()) ? map.getUndertakerId() : "";
                if (StringUtils.isNotBlank((CharSequence)userId) && !userIds.contains(userId)) {
                    userIds = Y9Util.genCustomStr((String)userIds, (String)userId);
                }
                String opinion = StringUtils.isNotBlank((CharSequence)map.getOpinion()) ? map.getOpinion() : "";
                String startTime = StringUtils.isNotBlank((CharSequence)map.getStartTime()) ? map.getStartTime() : "";
                String endTime = StringUtils.isNotBlank((CharSequence)map.getEndTime()) ? map.getEndTime() : "";
                String actionName = StringUtils.isNotBlank((CharSequence)map.getName()) ? map.getName() : "";
                HistoryInfo historyInfo = new HistoryInfo();
                historyInfo.setAssignee(assignee);
                historyInfo.setActionName(actionName);
                historyInfo.setEndTime(StringUtils.isNotBlank((CharSequence)endTime) ? sdf.parse(endTime) : new Date());
                historyInfo.setOpinionContent(opinion);
                historyInfo.setStartTime(StringUtils.isNotBlank((CharSequence)startTime) ? sdf.parse(startTime) : new Date());
                list.add(historyInfo);
            }
            retMap.put("userId", userIds);
            retMap.put("undertaker", undertaker);
            retMap.put("list", list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retMap;
    }

    public boolean saveToDateCenter(String processInstanceId) {
        LOGGER.info("************************************itemAdmin\u4fdd\u5b58\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3***********************************************");
        OfficeInfo officeInfo = new OfficeInfo();
        String tenantId = Y9LoginUserHolder.getTenantId();
        OrgUnit orgUnit = Y9LoginUserHolder.getOrgUnit();
        HistoricProcessInstanceModel processInstance = (HistoricProcessInstanceModel)this.historicProcessApi.getById(Y9LoginUserHolder.getTenantId(), processInstanceId).getData();
        HistoricVariableInstanceModel vmap = (HistoricVariableInstanceModel)this.historicVariableApi.getByProcessInstanceIdAndVariableName(tenantId, processInstanceId, "infoOvert", "").getData();
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String itemId = processParam.getItemId();
        String documentTitle = processParam.getTitle();
        String level = processParam.getCustomLevel();
        String number = processParam.getCustomNumber();
        String processSerialNumber = processParam.getProcessSerialNumber();
        String systemCnName = processParam.getSystemCnName();
        String systemName = processParam.getSystemName();
        String infoOvert = vmap == null || vmap.getValue() == null ? "" : vmap.getValue().toString();
        SpmApproveItem spmApproveItem = this.spmApproveitemService.findById(itemId);
        String startProUserId = processInstance.getStartUserId();
        String startUserId = startProUserId.contains(":") ? startProUserId.split(":")[0] : startProUserId;
        OrgUnit startProUser = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, startUserId).getData();
        OrgUnit dept = (OrgUnit)this.orgUnitApi.getBureau(tenantId, startProUser.getParentId()).getData();
        Map<String, Object> map = this.historyExcel(processSerialNumber, processInstanceId);
        String userId = (String)map.get("userId");
        List hisList = (List)map.get("list");
        TransactionWord word = this.transactionWordService.getByProcessSerialNumber(processSerialNumber);
        String textUrl = "";
        if (word != null && StringUtils.isNotBlank((CharSequence)word.getFileStoreId())) {
            textUrl = word.getFileStoreId();
        }
        List<TransactionFile> fileList = this.transactionFileService.listByProcessSerialNumber(processSerialNumber);
        ArrayList<AttachmentInfo> aList = new ArrayList<AttachmentInfo>();
        for (TransactionFile file : fileList) {
            AttachmentInfo info = new AttachmentInfo();
            info.setFileContent(null);
            info.setFileId(file.getFileStoreId());
            info.setFileName(file.getName());
            info.setFileType(file.getFileType());
            info.setFileUrl(null);
            aList.add(info);
        }
        AssociatedFile associatedFile = this.associatedFileRepository.findByProcessSerialNumber(processSerialNumber);
        String associatedId = "";
        if (associatedFile != null) {
            associatedId = associatedFile.getAssociatedId();
        }
        officeInfo.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        officeInfo.setTenantId(tenantId);
        officeInfo.setCompleteUserName(orgUnit.getName());
        officeInfo.setCreatDeptName(dept.getName());
        officeInfo.setCreatUserName(startProUser.getName());
        officeInfo.setEndTime(processInstance.getEndTime() == null ? new Date() : processInstance.getEndTime());
        officeInfo.setStartTime(processInstance.getStartTime());
        officeInfo.setAppCnName(spmApproveItem != null ? spmApproveItem.getName() : "");
        officeInfo.setSystemCnName(systemCnName);
        officeInfo.setSystemName(systemName);
        officeInfo.setDocNature("");
        officeInfo.setFilingDept(dept.getName());
        officeInfo.setFilingMan(orgUnit.getName());
        officeInfo.setProcessInstanceId(processInstanceId);
        officeInfo.setProcessSerialNumber(processSerialNumber);
        officeInfo.setSecurityLevel("\u4e00\u822c");
        officeInfo.setSerialNumber(number);
        officeInfo.setText("");
        officeInfo.setTextUrl(textUrl);
        officeInfo.setTitle(documentTitle);
        officeInfo.setUndertaker(userId);
        officeInfo.setUrgency(level);
        officeInfo.setAssociatedId(associatedId);
        officeInfo.setDisabled(infoOvert.equals("1") ? "1" : "0");
        officeInfo.setHistorys(hisList);
        officeInfo.setAttachments(aList);
        String processDefinitionId = processInstance.getProcessDefinitionId();
        List<EformInfo> elist = this.getEformInfo(processInstanceId, processDefinitionId.split(":")[0], processDefinitionId);
        officeInfo.setEforms(elist);
        boolean b = this.officeInfoApi.saveOfficeInfo(tenantId, officeInfo);
        LOGGER.info("*****officeInfo\u6570\u4fdd\u5b58\u5230\u6570\u636e\u4e2d\u5fc3 {} *****", (Object)b);
        LOGGER.info("-----\u529e\u7ed3\u6570\u636e\uff1a{}", (Object)officeInfo);
        return b;
    }

    public boolean saveToDateCenter1(String processInstanceId, String processDefinitionId) {
        LOGGER.info("************************************itemAdmin\u4fdd\u5b58\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3***********************************************");
        OfficeInfo officeInfo = new OfficeInfo();
        String tenantId = Y9LoginUserHolder.getTenantId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String sql = "SELECT v.TEXT_ from act_hi_varinst_2023 v where v.NAME_ = 'infoOvert' and v.PROC_INST_ID_ = '" + processInstanceId + "'";
            List list0 = this.jdbcTemplate4Tenant.queryForList(sql);
            ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
            String itemId = processParam.getItemId();
            String documentTitle = processParam.getTitle();
            String level = processParam.getCustomLevel();
            String number = processParam.getCustomNumber();
            String processSerialNumber = processParam.getProcessSerialNumber();
            String systemCnName = processParam.getSystemCnName();
            String systemName = processParam.getSystemName();
            String infoOvert = list0.isEmpty() ? "" : (String)((Map)list0.get(0)).get("TEXT_");
            SpmApproveItem spmApproveItem = this.spmApproveitemService.findById(itemId);
            String startProUserId = processParam.getStartor();
            String startUserId = startProUserId.contains(":") ? startProUserId.split(":")[0] : startProUserId;
            OrgUnit startProUser = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, startUserId).getData();
            OrgUnit dept = (OrgUnit)this.orgUnitApi.getBureau(tenantId, startProUser.getParentId()).getData();
            Map<String, Object> map = this.historyExcel(processSerialNumber, processInstanceId);
            String userId = (String)map.get("userId");
            List hisList = (List)map.get("list");
            TransactionWord word = this.transactionWordService.getByProcessSerialNumber(processSerialNumber);
            String textUrl = "";
            if (word != null && StringUtils.isNotBlank((CharSequence)word.getFileStoreId())) {
                textUrl = word.getFileStoreId();
            }
            List<TransactionFile> fileList = this.transactionFileService.listByProcessSerialNumber(processSerialNumber);
            ArrayList<AttachmentInfo> aList = new ArrayList<AttachmentInfo>();
            for (TransactionFile file : fileList) {
                AttachmentInfo info = new AttachmentInfo();
                info.setFileContent(null);
                info.setFileId(file.getFileStoreId());
                info.setFileName(file.getName());
                info.setFileType(file.getFileType());
                info.setFileUrl(null);
                aList.add(info);
            }
            AssociatedFile associatedFile = this.associatedFileRepository.findByProcessSerialNumber(processSerialNumber);
            String associatedId = "";
            if (associatedFile != null) {
                associatedId = associatedFile.getAssociatedId();
            }
            sql = "SELECT SUBSTRING(P.START_TIME_,1,19) as START_TIME_,SUBSTRING(P.END_TIME_,1,19) as END_TIME_ FROM ACT_HI_PROCINST_2023 P WHERE P .PROC_INST_ID_ ='" + processInstanceId + "'";
            List list1 = this.jdbcTemplate4Tenant.queryForList(sql);
            officeInfo.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            officeInfo.setTenantId(tenantId);
            officeInfo.setCompleteUserName(processParam.getCompleter());
            officeInfo.setCreatDeptName(dept.getName());
            officeInfo.setCreatUserName(startProUser.getName());
            officeInfo.setEndTime(sdf.parse(((Map)list1.get(0)).get("END_TIME_").toString()));
            officeInfo.setStartTime(sdf.parse(((Map)list1.get(0)).get("START_TIME_").toString()));
            officeInfo.setAppCnName(spmApproveItem != null ? spmApproveItem.getName() : "");
            officeInfo.setSystemCnName(systemCnName);
            officeInfo.setSystemName(systemName);
            officeInfo.setDocNature("");
            officeInfo.setFilingDept(dept.getName());
            officeInfo.setFilingMan(processParam.getCompleter());
            officeInfo.setProcessInstanceId(processInstanceId);
            officeInfo.setProcessSerialNumber(processSerialNumber);
            officeInfo.setSecurityLevel("\u4e00\u822c");
            officeInfo.setSerialNumber(number);
            officeInfo.setText("");
            officeInfo.setTextUrl(textUrl);
            officeInfo.setTitle(documentTitle);
            officeInfo.setUndertaker(userId);
            officeInfo.setUrgency(level);
            officeInfo.setAssociatedId(associatedId);
            officeInfo.setDisabled(infoOvert.equals("1") ? "1" : "0");
            officeInfo.setHistorys(hisList);
            officeInfo.setAttachments(aList);
            List<EformInfo> elist = this.getEformInfo(processInstanceId, processDefinitionId.split(":")[0], processDefinitionId);
            officeInfo.setEforms(elist);
            boolean b = this.officeInfoApi.saveOfficeInfo(tenantId, officeInfo);
            LOGGER.info("*****officeInfo\u6570\u4fdd\u5b58\u5230\u6570\u636e\u4e2d\u5fc3 {} *****", (Object)b);
            LOGGER.info("-----\u529e\u7ed3\u6570\u636e\uff1a{}", (Object)officeInfo);
            return b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

