/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.TaskTimeConf;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.config.TaskTimeConfService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/taskTimeConfig"}, produces={"application/json"})
public class TaskTimeConfRestController {
    private final TaskTimeConfService taskTimeConfService;
    private final ProcessDefinitionApi processDefinitionApi;

    @PostMapping(value={"/copyTaskConfig"})
    public Y9Result<String> copyTaskConfig(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.taskTimeConfService.copyTaskConf(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<TaskTimeConf>> getBpmList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        ArrayList<TaskTimeConf> resList = new ArrayList<TaskTimeConf>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
        for (TargetModel targetModel : list) {
            if (!StringUtils.isNotBlank((CharSequence)targetModel.getTaskDefKey())) continue;
            TaskTimeConf conf = this.taskTimeConfService.findByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, targetModel.getTaskDefKey());
            if (conf == null) {
                conf = new TaskTimeConf();
                conf.setId("");
                conf.setTimeoutInterrupt(Integer.valueOf(0));
                conf.setLeastTime(Integer.valueOf(0));
            }
            conf.setTaskType("\u5355\u4eba");
            if (targetModel.getMultiInstance().equals("parallel")) {
                conf.setTaskType("\u5e76\u884c");
            } else if (targetModel.getMultiInstance().equals("sequential")) {
                conf.setTaskType("\u4e32\u884c");
            }
            conf.setItemId(itemId);
            conf.setTaskDefName(targetModel.getTaskDefName());
            conf.setTaskDefKey(targetModel.getTaskDefKey());
            conf.setProcessDefinitionId(processDefinitionId);
            resList.add(conf);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(TaskTimeConf conf) {
        this.taskTimeConfService.save(conf);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public TaskTimeConfRestController(TaskTimeConfService taskTimeConfService, ProcessDefinitionApi processDefinitionApi) {
        this.taskTimeConfService = taskTimeConfService;
        this.processDefinitionApi = processDefinitionApi;
    }
}

