/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemTaskConf;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.config.ItemTaskConfService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemTaskConfig"}, produces={"application/json"})
public class ItemTaskConfRestController {
    private final ItemTaskConfService taskConfService;
    private final ProcessDefinitionApi processDefinitionApi;

    @PostMapping(value={"/copyTaskConfig"})
    public Y9Result<String> copyTaskConfig(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.taskConfService.copyTaskConf(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<Map<String, Object>>> getBpmList(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        ArrayList resList = new ArrayList();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
        for (TargetModel targetModel : list) {
            String taskDefKey;
            ItemTaskConf confTemp;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("taskDefName", targetModel.getTaskDefName());
            map.put("taskDefKey", targetModel.getTaskDefKey());
            if (targetModel.getMultiInstance() == null || targetModel.getMultiInstance().equals("sequential")) continue;
            map.put("id", "");
            map.put("signTask", false);
            map.put("taskType", "\u5355\u4eba");
            if (targetModel.getMultiInstance().equals("parallel")) {
                map.put("taskType", "\u5e76\u884c");
            }
            if (null != (confTemp = this.taskConfService.findByItemIdAndProcessDefinitionIdAndTaskDefKey4Own(itemId, processDefinitionId, taskDefKey = targetModel.getTaskDefKey()))) {
                map.put("id", confTemp.getId());
                map.put("signTask", confTemp.getSignTask());
            }
            resList.add(map);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> save(ItemTaskConf itemTaskConf) {
        this.taskConfService.save(itemTaskConf);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemTaskConfRestController(ItemTaskConfService taskConfService, ProcessDefinitionApi processDefinitionApi) {
        this.taskConfService = taskConfService;
        this.processDefinitionApi = processDefinitionApi;
    }
}

