/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.controller.vo.ItemNodeLinkBindVO;
import net.risesoft.entity.ItemLinkRole;
import net.risesoft.entity.ItemNodeLinkBind;
import net.risesoft.entity.LinkInfo;
import net.risesoft.model.platform.Role;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemLinkRoleRepository;
import net.risesoft.repository.jpa.LinkInfoRepository;
import net.risesoft.service.config.ItemNodeLinkBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemNodeLinkBind"}, produces={"application/json"})
public class ItemNodeLinkBindController {
    private final ItemNodeLinkBindService itemNodeLinkBindService;
    private final ProcessDefinitionApi processDefinitionApi;
    private final LinkInfoRepository linkInfoRepository;
    private final ItemLinkRoleRepository itemLinkRoleRepository;
    private final RoleApi roleApi;

    @PostMapping(value={"/copyBind"})
    public Y9Result<String> copyBind(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemNodeLinkBindService.copyBind(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<ItemNodeLinkBindVO>> getBpmList(@RequestParam String processDefinitionId, @RequestParam String itemId) {
        ArrayList<ItemNodeLinkBindVO> res_list = new ArrayList<ItemNodeLinkBindVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
        for (TargetModel targetModel : list) {
            ItemNodeLinkBindVO vo = new ItemNodeLinkBindVO();
            vo.setTaskDefKey(targetModel.getTaskDefKey());
            vo.setTaskDefName(targetModel.getTaskDefName());
            ItemNodeLinkBind bind = this.itemNodeLinkBindService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, targetModel.getTaskDefKey());
            if (bind != null) {
                LinkInfo linkInfo = this.linkInfoRepository.findById((Object)bind.getLinkId()).orElse(null);
                String name = linkInfo != null ? linkInfo.getLinkName() : "\u94fe\u63a5\u4e0d\u5b58\u5728";
                String url = linkInfo != null ? linkInfo.getLinkUrl() : "\u94fe\u63a5\u5730\u5740\u4e0d\u5b58\u5728";
                List rolelist = this.itemLinkRoleRepository.findByItemLinkId(bind.getId());
                Object roleNames = "";
                String roleBindIds = "";
                for (ItemLinkRole bindrole : rolelist) {
                    roleBindIds = Y9Util.genCustomStr((String)roleBindIds, (String)bindrole.getId(), (String)",");
                    Role role = (Role)this.roleApi.getRole(bindrole.getRoleId()).getData();
                    if (StringUtils.isEmpty((CharSequence)roleNames)) {
                        roleNames = null == role ? "\u89d2\u8272\u4e0d\u5b58\u5728" : role.getName();
                        continue;
                    }
                    roleNames = (String)roleNames + "\u3001" + (null == role ? "\u89d2\u8272\u4e0d\u5b58\u5728" : role.getName());
                }
                vo.setLinkName(name + "(" + url + ")");
                vo.setRoleNames((String)roleNames);
                vo.setRoleBindIds(roleBindIds);
                vo.setLinkBindId(bind.getId());
            }
            res_list.add(vo);
        }
        return Y9Result.success(res_list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeBind"})
    public Y9Result<String> removeBind(@RequestParam String bindId) {
        this.itemNodeLinkBindService.removeBind(bindId);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/removeRole"})
    public Y9Result<String> removeRole(@RequestParam String[] ids) {
        this.itemNodeLinkBindService.removeRole(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBindRole"})
    public Y9Result<String> saveBindRole(@RequestParam String roleIds, @RequestParam String itemLinkId) {
        this.itemNodeLinkBindService.saveBindRole(itemLinkId, roleIds);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveItemLinkBind"})
    public Y9Result<String> saveItemLinkBind(@RequestParam String linkId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey, @RequestParam String itemId) {
        this.itemNodeLinkBindService.saveItemNodeLinkBind(itemId, linkId, processDefinitionId, taskDefKey);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemNodeLinkBindController(ItemNodeLinkBindService itemNodeLinkBindService, ProcessDefinitionApi processDefinitionApi, LinkInfoRepository linkInfoRepository, ItemLinkRoleRepository itemLinkRoleRepository, RoleApi roleApi) {
        this.itemNodeLinkBindService = itemNodeLinkBindService;
        this.processDefinitionApi = processDefinitionApi;
        this.linkInfoRepository = linkInfoRepository;
        this.itemLinkRoleRepository = itemLinkRoleRepository;
        this.roleApi = roleApi;
    }
}

