/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.List;
import lombok.Generated;
import net.risesoft.entity.ItemLinkBind;
import net.risesoft.entity.ItemLinkRole;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.config.ItemLinkBindService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/itemLinkBind"}, produces={"application/json"})
public class ItemLinkBindController {
    private final ItemLinkBindService itemLinkBindService;

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemLinkBind>> getBindList(@RequestParam String itemId) {
        List<ItemLinkBind> list = this.itemLinkBindService.listByItemId(itemId);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindRoleList"})
    public Y9Result<List<ItemLinkRole>> getBindRoleList(@RequestParam String itemLinkId) {
        List<ItemLinkRole> list = this.itemLinkBindService.listWithBindRole(itemLinkId);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeBind"})
    public Y9Result<String> removeBind(@RequestParam String[] ids) {
        this.itemLinkBindService.removeBind(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/removeRole"})
    public Y9Result<String> removeRole(@RequestParam String[] ids) {
        this.itemLinkBindService.removeRole(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBindRole"})
    public Y9Result<String> saveBindRole(@RequestParam String roleIds, @RequestParam String itemLinkId) {
        this.itemLinkBindService.saveBindRole(itemLinkId, roleIds);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveItemLinkBind"})
    public Y9Result<String> saveItemLinkBind(@RequestParam String[] linkIds, @RequestParam String itemId) {
        this.itemLinkBindService.saveItemLinkBind(itemId, linkIds);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemLinkBindController(ItemLinkBindService itemLinkBindService) {
        this.itemLinkBindService = itemLinkBindService;
    }
}

