/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemInterfaceTaskBind;
import net.risesoft.model.processadmin.FlowElementModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemInterfaceTaskBindRepository;
import net.risesoft.service.config.ItemInterfaceTaskBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/interfaceTaskBind"}, produces={"application/json"})
public class ItemInterfaceTaskBindController {
    private final ProcessDefinitionApi processDefinitionApi;
    private final ItemInterfaceTaskBindService itemInterfaceTaskBindService;
    private final ItemInterfaceTaskBindRepository itemInterfaceTaskBindRepository;

    @PostMapping(value={"/copyBind"})
    public Y9Result<String> copyBind(@RequestParam String interfaceId, @RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemInterfaceTaskBindService.copyBind(itemId, interfaceId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<FlowElementModel>> getBpmList(@RequestParam String itemId, @RequestParam String interfaceId, @RequestParam String processDefinitionId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionApi.getFlowElement(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
        for (FlowElementModel feModel : list) {
            String elementKey = feModel.getElementKey();
            ItemInterfaceTaskBind bind = this.itemInterfaceTaskBindRepository.findByTaskDefKeyAndItemIdAndProcessDefinitionIdAndInterfaceId(elementKey, itemId, processDefinitionId, interfaceId);
            feModel.setBind(false);
            if (bind == null) continue;
            feModel.setBind(true);
            feModel.setCondition(bind.getExecuteCondition());
        }
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(@RequestParam String interfaceId, @RequestParam String itemId, @RequestParam String processDefinitionId, String elementKey, @RequestParam String condition) {
        this.itemInterfaceTaskBindService.saveBind(itemId, interfaceId, processDefinitionId, elementKey, condition);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemInterfaceTaskBindController(ProcessDefinitionApi processDefinitionApi, ItemInterfaceTaskBindService itemInterfaceTaskBindService, ItemInterfaceTaskBindRepository itemInterfaceTaskBindRepository) {
        this.processDefinitionApi = processDefinitionApi;
        this.itemInterfaceTaskBindService = itemInterfaceTaskBindService;
        this.itemInterfaceTaskBindRepository = itemInterfaceTaskBindRepository;
    }
}

