/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.entity.ItemInterfaceParamsBind;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.entity.form.Y9TableField;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemInterfaceParamsBindRepository;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemInterfaceParamsBindService;
import net.risesoft.service.form.Y9TableFieldService;
import net.risesoft.service.form.Y9TableService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/interfaceParamsBind"}, produces={"application/json"})
public class ItemInterfaceParamsBindController {
    private final ItemInterfaceParamsBindService itemInterfaceParamsBindService;
    private final SpmApproveItemService spmApproveItemService;
    private final Y9TableService y9TableService;
    private final Y9TableFieldService y9TableFieldService;
    private final ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository;

    @GetMapping(value={"/getBindInfo"})
    public Y9Result<Map<String, Object>> getBindInfo(@RequestParam(required=false) String id, @RequestParam String itemId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        Y9Page<Y9Table> pageList = this.y9TableService.pageTables(item.getSystemName(), 1, 500);
        ArrayList<String> tableNameList = new ArrayList<String>();
        ArrayList<Y9Table> tableList = new ArrayList<Y9Table>();
        ArrayList tableField = new ArrayList();
        for (Y9Table table : pageList.getRows()) {
            tableNameList.add(table.getTableName());
            tableList.add(table);
            HashMap<String, Object> tableFieldMap = new HashMap<String, Object>();
            tableFieldMap.put("tableName", table.getTableName());
            List<Y9TableField> fieldlist = this.y9TableFieldService.listByTableId(table.getId());
            tableFieldMap.put("fieldlist", fieldlist);
            tableField.add(tableFieldMap);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ItemInterfaceParamsBind info = this.itemInterfaceParamsBindRepository.findById((Object)id).orElse(null);
            resMap.put("info", info);
        }
        resMap.put("tableList", tableList);
        resMap.put("tablefield", tableField);
        return Y9Result.success(resMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemInterfaceParamsBind>> getBindList(@RequestParam String itemId, @RequestParam String interfaceId, @RequestParam String type) {
        List<ItemInterfaceParamsBind> list = this.itemInterfaceParamsBindService.listByItemIdAndInterfaceIdAndType(itemId, interfaceId, type);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeBind"})
    public Y9Result<String> removeBind(@RequestParam String id) {
        this.itemInterfaceParamsBindService.removeBind(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(ItemInterfaceParamsBind info) {
        this.itemInterfaceParamsBindService.saveBind(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemInterfaceParamsBindController(ItemInterfaceParamsBindService itemInterfaceParamsBindService, SpmApproveItemService spmApproveItemService, Y9TableService y9TableService, Y9TableFieldService y9TableFieldService, ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository) {
        this.itemInterfaceParamsBindService = itemInterfaceParamsBindService;
        this.spmApproveItemService = spmApproveItemService;
        this.y9TableService = y9TableService;
        this.y9TableFieldService = y9TableFieldService;
        this.itemInterfaceParamsBindRepository = itemInterfaceParamsBindRepository;
    }
}

