/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.entity.ItemViewConf;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.ViewType;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.ViewTypeService;
import net.risesoft.service.config.ItemViewConfService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/viewType"}, produces={"application/json"})
public class ViewTypeRestController {
    private final ViewTypeService viewTypeService;
    private final ItemViewConfService itemViewConfService;
    private final SpmApproveItemService spmApproveItemService;

    @GetMapping(value={"/findById"})
    public Y9Result<ViewType> getOpinionFrame(@RequestParam String id) {
        ViewType viewType = this.viewTypeService.findById(id);
        return Y9Result.success((Object)viewType, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/list"})
    public Y9Page<ViewType> list(@RequestParam Integer page, @RequestParam Integer rows) {
        Page<ViewType> pageList = this.viewTypeService.pageAll(page, rows);
        List list = pageList.getContent();
        for (ViewType viewType : list) {
            StringBuilder itemIds = new StringBuilder();
            StringBuilder itemNames = new StringBuilder();
            List<ItemViewConf> ivcList = this.itemViewConfService.listByViewType(viewType.getMark());
            for (ItemViewConf ivc : ivcList) {
                SpmApproveItem item;
                String itemId = ivc.getItemId();
                if (itemIds.toString().contains(itemId) || null == (item = this.spmApproveItemService.findById(itemId))) continue;
                itemIds.append(itemId).append(";");
                if (StringUtils.isEmpty((CharSequence)itemNames)) {
                    itemNames.append(item.getName());
                    continue;
                }
                itemNames.append("\u3001" + item.getName());
            }
            viewType.setItemNames(itemNames.toString());
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)list, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @GetMapping(value={"/listAll"})
    public Y9Result<List<ViewType>> listAll() {
        List<ViewType> list = this.viewTypeService.listAll();
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String[] ids) {
        this.viewTypeService.remove(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(ViewType viewType) {
        ViewType oldViewType;
        String id = viewType.getId();
        if (StringUtils.isEmpty((CharSequence)id) && null != (oldViewType = this.viewTypeService.findByMark(viewType.getMark()))) {
            return Y9Result.failure((String)("\u4fdd\u5b58\u5931\u8d25\uff1a\u552f\u4e00\u6807\u793a\u3010" + viewType.getMark() + "\u3011\u5df2\u5b58\u5728"));
        }
        this.viewTypeService.saveOrUpdate(viewType);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/search"})
    public Y9Page<ViewType> search(@RequestParam Integer page, @RequestParam Integer rows, @RequestParam(required=false) String keyword) {
        Page<ViewType> pageList = this.viewTypeService.search(page, rows, keyword);
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @Generated
    public ViewTypeRestController(ViewTypeService viewTypeService, ItemViewConfService itemViewConfService, SpmApproveItemService spmApproveItemService) {
        this.viewTypeService = viewTypeService;
        this.itemViewConfService = itemViewConfService;
        this.spmApproveItemService = spmApproveItemService;
    }
}

