/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.vo.NodeTreeVO;
import net.risesoft.entity.ReceiveDepartment;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ReceiveDepartmentRepository;
import net.risesoft.service.ReceiveDeptAndPersonService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/sendReceive"}, produces={"application/json"})
public class SendReceiveRestController {
    private final ReceiveDeptAndPersonService receiveDeptAndPersonService;
    private final OrganizationApi organizationApi;
    private final OrgUnitApi orgUnitApi;
    private final PersonApi personApi;
    private final DepartmentApi departmentApi;
    private final ReceiveDepartmentRepository receiveDepartmentRepository;

    @PostMapping(value={"/checkReceiveSend"})
    public Y9Result<String> checkReceiveSend(@RequestParam String deptId) {
        ReceiveDepartment receiveDept = this.receiveDeptAndPersonService.findByDeptId(deptId);
        if (receiveDept != null) {
            return Y9Result.successMsg((String)"true");
        }
        return Y9Result.failure((String)"false");
    }

    @PostMapping(value={"/delPerson"})
    public Y9Result<String> delPerson(@RequestParam String id) {
        return this.receiveDeptAndPersonService.delPerson(id);
    }

    @GetMapping(value={"/deptTreeSearch"})
    public Y9Result<List<NodeTreeVO>> deptTreeSearch(@RequestParam(required=false) String name, @RequestParam String deptId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<NodeTreeVO> item = new ArrayList<NodeTreeVO>();
        List personList = (List)this.personApi.listRecursivelyByParentIdAndName(tenantId, deptId, name).getData();
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        for (Person person : personList) {
            orgUnitList.add((OrgUnit)person);
            Person p = (Person)this.personApi.get(tenantId, person.getId()).getData();
            this.recursionUpToOrg(tenantId, deptId, p.getParentId(), orgUnitList, false);
        }
        for (OrgUnit orgUnit : orgUnitList) {
            NodeTreeVO nodeTreeVO = new NodeTreeVO();
            nodeTreeVO.setId(orgUnit.getId());
            nodeTreeVO.setName(orgUnit.getName());
            nodeTreeVO.setOrgType(orgUnit.getOrgType().getValue());
            nodeTreeVO.setParentId(orgUnit.getParentId());
            nodeTreeVO.setIsParent(true);
            if (OrgTypeEnum.PERSON.equals((Object)orgUnit.getOrgType())) {
                Person per = (Person)this.personApi.get(Y9LoginUserHolder.getTenantId(), orgUnit.getId()).getData();
                nodeTreeVO.setIsParent(false);
                nodeTreeVO.setSex(per.getSex().getValue());
                nodeTreeVO.setDuty(per.getDuty());
            }
            item.add(nodeTreeVO);
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getDeptTree"})
    public Y9Result<List<NodeTreeVO>> getDeptTrees(@RequestParam(required=false) String id, @RequestParam(required=false) String deptId) {
        Department dept;
        ArrayList<NodeTreeVO> item = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)deptId) && (dept = (Department)this.departmentApi.get(tenantId, deptId).getData()) != null && dept.getId() != null) {
            NodeTreeVO nodeTreeVO = new NodeTreeVO();
            nodeTreeVO.setId(dept.getId());
            nodeTreeVO.setName(dept.getName());
            nodeTreeVO.setOrgType(dept.getOrgType().getValue());
            nodeTreeVO.setParentId(dept.getParentId());
            nodeTreeVO.setIsParent(true);
            item.add(nodeTreeVO);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List orgList = (List)this.orgUnitApi.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_ORG).getData();
            for (OrgUnit orgunit : orgList) {
                NodeTreeVO nodeTreeVO = new NodeTreeVO();
                nodeTreeVO.setId(orgunit.getId());
                nodeTreeVO.setName(orgunit.getName());
                nodeTreeVO.setOrgType(orgunit.getOrgType().getValue());
                nodeTreeVO.setParentId(id);
                if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                    nodeTreeVO.setIsParent(true);
                } else {
                    if (!OrgTypeEnum.PERSON.equals((Object)orgunit.getOrgType())) continue;
                    Person person = (Person)this.personApi.get(tenantId, orgunit.getId()).getData();
                    nodeTreeVO.setIsParent(false);
                    nodeTreeVO.setSex(person.getSex().getValue());
                    nodeTreeVO.setDuty(person.getDuty());
                }
                item.add(nodeTreeVO);
            }
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrg"})
    public Y9Result<List<Organization>> getOrg() {
        List list = (List)this.organizationApi.list(Y9LoginUserHolder.getTenantId()).getData();
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrgChildTree"})
    public Y9Result<List<NodeTreeVO>> getOrgChildTree(@RequestParam(required=false) String id, OrgTreeTypeEnum treeType) {
        ArrayList<NodeTreeVO> item = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List orgList = (List)this.orgUnitApi.getSubTree(tenantId, id, treeType).getData();
            for (OrgUnit orgunit : orgList) {
                NodeTreeVO nodeTreeVO = new NodeTreeVO();
                nodeTreeVO.setId(orgunit.getId());
                nodeTreeVO.setName(orgunit.getName());
                nodeTreeVO.setOrgType(orgunit.getOrgType().getValue());
                nodeTreeVO.setParentId(id);
                nodeTreeVO.setGuidPath(orgunit.getGuidPath());
                if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                    nodeTreeVO.setIsParent(true);
                } else if (OrgTypeEnum.PERSON.equals((Object)orgunit.getOrgType())) {
                    Person person = (Person)this.personApi.get(tenantId, orgunit.getId()).getData();
                    nodeTreeVO.setIsParent(false);
                    nodeTreeVO.setSex(person.getSex().getValue());
                    nodeTreeVO.setDuty(person.getDuty());
                } else {
                    if (!OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) continue;
                    nodeTreeVO.setIsParent(false);
                }
                item.add(nodeTreeVO);
            }
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrgTree"})
    public Y9Result<List<OrgUnit>> getOrgTree(@RequestParam String id, @RequestParam OrgTreeTypeEnum treeType) {
        ArrayList<OrgUnit> newOrgUnitList = new ArrayList<OrgUnit>();
        List orgUnitList = (List)this.orgUnitApi.getSubTree(Y9LoginUserHolder.getTenantId(), id, treeType).getData();
        for (OrgUnit orgUnit : orgUnitList) {
            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) continue;
            orgUnit.setDn("false");
            ReceiveDepartment receiveDepartment = this.receiveDeptAndPersonService.findByDeptId(orgUnit.getId());
            List deptList = (List)this.departmentApi.listRecursivelyByParentId(Y9LoginUserHolder.getTenantId(), orgUnit.getId()).getData();
            orgUnit.setGuidPath("false");
            for (Department dept : deptList) {
                orgUnit.setGuidPath("true");
                ReceiveDepartment receiveDept = this.receiveDeptAndPersonService.findByDeptId(dept.getId());
                if (receiveDept == null) continue;
                orgUnit.setDn("true");
                break;
            }
            orgUnit.setCustomId("false");
            orgUnit.setProperties("false");
            if (receiveDepartment != null) {
                orgUnit.setCustomId("true");
                Integer count = this.receiveDeptAndPersonService.countByDeptId(orgUnit.getId());
                if (count > 0) {
                    orgUnit.setProperties("true");
                }
            }
            newOrgUnitList.add(orgUnit);
        }
        return Y9Result.success(newOrgUnitList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public OrgUnit getParent(String tenantId, String parentId) {
        Organization parent = (Organization)this.organizationApi.get(tenantId, parentId).getData();
        return parent.getId() != null ? parent : (OrgUnit)this.departmentApi.get(tenantId, parentId).getData();
    }

    @RequestMapping(value={"/orderDeptList"})
    public Y9Result<List<ReceiveDepartment>> orderDeptList() {
        List list = this.receiveDepartmentRepository.findAllOrderByTabIndex();
        for (ReceiveDepartment receiveDeptAndPerson : list) {
            Department department = (Department)this.departmentApi.get(Y9LoginUserHolder.getTenantId(), receiveDeptAndPerson.getDeptId()).getData();
            receiveDeptAndPerson.setDeptName(department.getName());
        }
        return Y9Result.success((Object)list);
    }

    @GetMapping(value={"/orgTreeSearch"})
    public Y9Result<List<OrgUnit>> orgTreeSearch(@RequestParam OrgTreeTypeEnum treeType, @RequestParam String name) {
        ArrayList<OrgUnit> newOrgUnitList = new ArrayList<OrgUnit>();
        List orgUnitList = (List)this.orgUnitApi.treeSearch(Y9LoginUserHolder.getTenantId(), name, treeType).getData();
        for (OrgUnit orgUnit : orgUnitList) {
            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) continue;
            orgUnit.setDn("false");
            ReceiveDepartment receiveDepartment = this.receiveDeptAndPersonService.findByDeptId(orgUnit.getId());
            List deptList = (List)this.departmentApi.listRecursivelyByParentId(Y9LoginUserHolder.getTenantId(), orgUnit.getId()).getData();
            orgUnit.setGuidPath("false");
            for (Department dept : deptList) {
                orgUnit.setGuidPath("true");
                ReceiveDepartment receiveDept = this.receiveDeptAndPersonService.findByDeptId(dept.getId());
                if (receiveDept == null) continue;
                orgUnit.setDn("true");
                break;
            }
            orgUnit.setCustomId("false");
            orgUnit.setProperties("false");
            if (receiveDepartment != null) {
                orgUnit.setCustomId("true");
                Integer count = this.receiveDeptAndPersonService.countByDeptId(orgUnit.getId());
                if (count > 0) {
                    orgUnit.setProperties("true");
                }
            }
            newOrgUnitList.add(orgUnit);
        }
        List list = (List)this.organizationApi.list(Y9LoginUserHolder.getTenantId()).getData();
        if (!list.isEmpty()) {
            newOrgUnitList.addAll(list);
        }
        return Y9Result.success(newOrgUnitList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/personList"})
    public Y9Result<List<Map<String, Object>>> personList(@RequestParam String deptId) {
        List<Map<String, Object>> personList = this.receiveDeptAndPersonService.personList(deptId);
        return Y9Result.success(personList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public void recursionUpToOrg(String tenantId, String nodeId, String parentId, List<OrgUnit> orgUnitList, boolean isParent) {
        OrgUnit parent = this.getParent(tenantId, parentId);
        if (isParent) {
            parent.setDescription("parent");
        }
        if (orgUnitList.isEmpty()) {
            orgUnitList.add(parent);
        } else {
            boolean add = true;
            for (OrgUnit orgUnit : orgUnitList) {
                if (!orgUnit.getId().equals(parent.getId())) continue;
                add = false;
                break;
            }
            if (add) {
                orgUnitList.add(parent);
            }
        }
        if (parent.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
            if (parent.getId().equals(nodeId)) {
                return;
            }
            this.recursionUpToOrg(tenantId, nodeId, parent.getParentId(), orgUnitList, true);
        }
    }

    @PostMapping(value={"/saveOrCancelDept"})
    public Y9Result<String> saveOrCancelDept(@RequestParam String id, @RequestParam String type) {
        String save = "save";
        if (type.equals(save)) {
            return this.receiveDeptAndPersonService.saveDepartment(id);
        }
        return this.receiveDeptAndPersonService.delDepartment(id);
    }

    @RequestMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(String ids) {
        return this.receiveDeptAndPersonService.saveOrder(ids);
    }

    @PostMapping(value={"/savePerson"})
    public Y9Result<String> savePerson(@RequestParam String deptId, @RequestParam String ids) {
        return this.receiveDeptAndPersonService.savePosition(deptId, ids);
    }

    @GetMapping(value={"/searchOrgTree"})
    public Y9Result<List<OrgUnit>> searchOrgTree(@RequestParam OrgTreeTypeEnum treeType, @RequestParam String name) {
        List orgUnitList = (List)this.orgUnitApi.treeSearch(Y9LoginUserHolder.getTenantId(), name, treeType).getData();
        return Y9Result.success((Object)orgUnitList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/setReceive"})
    public Y9Result<String> setReceive(@RequestParam boolean receive, @RequestParam String ids) {
        return this.receiveDeptAndPersonService.setReceive(receive, ids);
    }

    @PostMapping(value={"/setSend"})
    public Y9Result<String> setSend(@RequestParam boolean send, @RequestParam String ids) {
        return this.receiveDeptAndPersonService.setSend(send, ids);
    }

    @Generated
    public SendReceiveRestController(ReceiveDeptAndPersonService receiveDeptAndPersonService, OrganizationApi organizationApi, OrgUnitApi orgUnitApi, PersonApi personApi, DepartmentApi departmentApi, ReceiveDepartmentRepository receiveDepartmentRepository) {
        this.receiveDeptAndPersonService = receiveDeptAndPersonService;
        this.organizationApi = organizationApi;
        this.orgUnitApi = orgUnitApi;
        this.personApi = personApi;
        this.departmentApi = departmentApi;
        this.receiveDepartmentRepository = receiveDepartmentRepository;
    }
}

