/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.entity.ItemPrintTemplateBind;
import net.risesoft.entity.PrintTemplate;
import net.risesoft.entity.form.Y9Form;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9FormRepository;
import net.risesoft.service.PrintTemplateService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/vue/printTemplate"}, produces={"application/json"})
public class PrintRestController {
    private final PrintTemplateService printTemplateService;
    private final Y9FormRepository y9FormRepository;

    @PostMapping(value={"/deleteBindPrintTemplate"})
    public Y9Result<String> deleteBindPrintTemplate(@RequestParam String id) {
        return this.printTemplateService.deleteBindPrintTemplate(id);
    }

    @PostMapping(value={"/deletePrintTemplate"})
    public Y9Result<String> deletePrintTemplate(@RequestParam String id) {
        return this.printTemplateService.deletePrintTemplate(id);
    }

    @RequestMapping(value={"/download"})
    public void download(@RequestParam String id, HttpServletResponse response, HttpServletRequest request) {
        this.printTemplateService.download(id, response, request);
    }

    @GetMapping(value={"/getPrintTemplateList"})
    public Y9Result<List<Map<String, Object>>> getPrintTemplateList(@RequestParam(required=false) String fileName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<PrintTemplate> list = StringUtils.isNotBlank((CharSequence)fileName) ? this.printTemplateService.listByFileNameLike(fileName) : this.printTemplateService.listAll();
        ArrayList items = new ArrayList();
        for (PrintTemplate printTemplate : list) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", printTemplate.getId());
            map.put("fileName", printTemplate.getFileName());
            map.put("fileSize", printTemplate.getFileSize());
            map.put("fileUrl", printTemplate.getFilePath());
            map.put("personName", printTemplate.getPersonName());
            map.put("uploadTime", sdf.format(printTemplate.getUploadTime()));
            items.add(map);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindTemplateList"})
    public Y9Result<List<ItemPrintTemplateBind>> getTemplateList(@RequestParam String itemId) {
        List<ItemPrintTemplateBind> list = this.printTemplateService.listTemplateBindByItemId(itemId);
        for (ItemPrintTemplateBind bind : list) {
            if (!bind.getTemplateType().equals("2")) continue;
            Y9Form form = this.y9FormRepository.findById((Object)bind.getTemplateId()).orElse(null);
            bind.setTemplateName(form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveBindTemplate"})
    public Y9Result<String> saveBindTemplate(@RequestParam String itemId, @RequestParam String templateId, @RequestParam String templateName, @RequestParam(required=false) String templateUrl, @RequestParam String templateType) {
        return this.printTemplateService.saveBindTemplate(itemId, templateId, templateName, templateUrl, templateType);
    }

    @PostMapping(value={"/uploadTemplate"})
    public Y9Result<String> upload(@RequestParam MultipartFile files) {
        return this.printTemplateService.uploadTemplate(files);
    }

    @Generated
    public PrintRestController(PrintTemplateService printTemplateService, Y9FormRepository y9FormRepository) {
        this.printTemplateService = printTemplateService;
        this.y9FormRepository = y9FormRepository;
    }
}

