/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.entity.ItemLinkBind;
import net.risesoft.entity.LinkInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.LinkInfoService;
import net.risesoft.service.config.ItemLinkBindService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/linkInfo"}, produces={"application/json"})
public class LinkInfoRestController {
    private final LinkInfoService linkInfoService;
    private final ItemLinkBindService itemLinkBindService;

    @GetMapping(value={"/findAll"})
    public Y9Result<List<LinkInfo>> findAll(@RequestParam(required=false) String linkName, @RequestParam(required=false) String linkUrl) {
        List<LinkInfo> list = this.linkInfoService.listAll(linkName, linkUrl);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @GetMapping(value={"/findById"})
    public Y9Result<LinkInfo> findById(@RequestParam String id) {
        LinkInfo info = this.linkInfoService.findById(id);
        return Y9Result.success((Object)info, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/findByLinkId"})
    public Y9Result<List<ItemLinkBind>> findByLinkId(@RequestParam String id) {
        List<ItemLinkBind> list = this.itemLinkBindService.listByLinkId(id);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String id) {
        this.linkInfoService.remove(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(LinkInfo info) {
        this.linkInfoService.saveOrUpdate(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public LinkInfoRestController(LinkInfoService linkInfoService, ItemLinkBindService itemLinkBindService) {
        this.linkInfoService = linkInfoService;
        this.itemLinkBindService = itemLinkBindService;
    }
}

