/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.entity.InterfaceInfo;
import net.risesoft.entity.InterfaceRequestParams;
import net.risesoft.entity.InterfaceResponseParams;
import net.risesoft.entity.ItemInterfaceBind;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.InterfaceService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/interface"}, produces={"application/json"})
public class InterfaceRestController {
    private final InterfaceService interfaceService;

    @GetMapping(value={"/findByInterfaceId"})
    public Y9Result<List<ItemInterfaceBind>> findByInterfaceId(@RequestParam String id) {
        List<ItemInterfaceBind> list = this.interfaceService.listInterfaceById(id);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/findInterfaceList"})
    public Y9Result<List<InterfaceInfo>> findInterfaceList(@RequestParam(required=false) String name, @RequestParam(required=false) String type, @RequestParam(required=false) String address) {
        List<InterfaceInfo> list = this.interfaceService.listInterfaces(name, type, address);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @GetMapping(value={"/findRequestParamsList"})
    public Y9Result<List<InterfaceRequestParams>> findRequestParamsList(@RequestParam(required=false) String name, @RequestParam(required=false) String type, @RequestParam String id) {
        List<InterfaceRequestParams> list = this.interfaceService.listRequestParams(name, type, id);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @GetMapping(value={"/findResponseParamsList"})
    public Y9Result<List<InterfaceResponseParams>> findResponseParamsList(@RequestParam(required=false) String name, @RequestParam String id) {
        List<InterfaceResponseParams> list = this.interfaceService.listResponseParamsByNameAndId(name, id);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    @PostMapping(value={"/removeInterface"})
    public Y9Result<String> removeInterface(@RequestParam String id) {
        this.interfaceService.removeInterface(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/removeRequestParams"})
    public Y9Result<String> removeRequestParams(@RequestParam String[] ids) {
        this.interfaceService.removeReqParams(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/removeResponseParams"})
    public Y9Result<String> removeResponseParams(@RequestParam String[] ids) {
        this.interfaceService.removeResParams(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveAllResponseParams"})
    public Y9Result<String> saveAllResponseParams(String interfaceId, String jsonData) {
        this.interfaceService.saveAllResponseParams(interfaceId, jsonData);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveInterface"})
    public Y9Result<String> saveInterface(InterfaceInfo info) {
        this.interfaceService.saveInterfaceInfo(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveRequestParams"})
    public Y9Result<String> saveRequestParams(InterfaceRequestParams info) {
        this.interfaceService.saveRequestParams(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveResponseParams"})
    public Y9Result<String> saveResponseParams(InterfaceResponseParams info) {
        this.interfaceService.saveResponseParams(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public InterfaceRestController(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }
}

